% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{get_db_discussions}
\alias{get_db_discussions}
\alias{get_db_topics}
\title{Retrieve data from ennet_db GitHub repository}
\usage{
get_db_discussions(repo = "katilingban/ennet_db", branch = "main")

get_db_topics(
  repo = "katilingban/ennet_db",
  branch = "main",
  id = c("daily", "weekly", "monthly", "yearly")
)
}
\arguments{
\item{repo}{A character value for the GitHub user and repository name
combination identifying the GitHub location for ennet_db. Default is
\code{katilingban/ennet_db}.}

\item{branch}{A character value for the branch name from which to retrieve
data. Default is \code{main}.}

\item{id}{A character value for data identifier. Possible choices are
\emph{daily}, \emph{weekly}, \emph{monthly}, or \emph{yearly}.}
}
\value{
A tibble of the specified dataset
}
\description{
Retrieve data from ennet_db GitHub repository
}
\examples{
\donttest{
  ## Retrieve discussions dataset
  get_db_discussions()
}

## Retrieve en-net topics yearly interactions dataset
get_db_topics(id = "yearly")

}
\author{
Ernest Guevarra
}
