testthat::context("Missing arguments")

# Check Missing NorP
testthat::test_that("Expected error messages are returned", {
  testthat::skip_on_cran()

  AbdVectorError <- "An argument NorP or Ns must be provided."
  testthat::expect_error(entropart:::Diversity.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Dqz.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Hqz.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::HqzBeta.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::GenSimpson.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::GenSimpsonD.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Hurlbert.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::HurlbertD.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::PhyloDiversity.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Rao.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Richness.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Shannon.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::ShannonBeta.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Simpson.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::SimpsonBeta.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::Tsallis.AbdVector(), AbdVectorError)
  testthat::expect_error(entropart:::TsallisBeta.AbdVector(), AbdVectorError)
  
  testthat::expect_error(entropart:::Diversity.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Dqz.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Hqz.integer(), AbdVectorError)
  testthat::expect_error(entropart:::HqzBeta.integer(), AbdVectorError)
  testthat::expect_error(entropart:::GenSimpson.integer(), AbdVectorError)
  testthat::expect_error(entropart:::GenSimpsonD.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Hurlbert.integer(), AbdVectorError)
  testthat::expect_error(entropart:::HurlbertD.integer(), AbdVectorError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.integer(), AbdVectorError)
  testthat::expect_error(entropart:::PhyloDiversity.integer(), AbdVectorError)
  testthat::expect_error(entropart:::PhyloEntropy.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Rao.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Richness.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Shannon.integer(), AbdVectorError)
  testthat::expect_error(entropart:::ShannonBeta.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Simpson.integer(), AbdVectorError)
  testthat::expect_error(entropart:::SimpsonBeta.integer(), AbdVectorError)
  testthat::expect_error(entropart:::Tsallis.integer(), AbdVectorError)
  testthat::expect_error(entropart:::TsallisBeta.integer(), AbdVectorError)
  
  AbdVectorExpError <- "An argument NorPexp or Nexp must be provided."
  testthat::expect_error(entropart:::HqzBeta.AbdVector(0), AbdVectorExpError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.AbdVector(0), AbdVectorExpError)
  testthat::expect_error(entropart:::ShannonBeta.AbdVector(0), AbdVectorExpError)
  testthat::expect_error(entropart:::SimpsonBeta.AbdVector(0), AbdVectorExpError)
  testthat::expect_error(entropart:::TsallisBeta.AbdVector(0), AbdVectorExpError)
  
  testthat::expect_error(entropart:::HqzBeta.integer(0), AbdVectorExpError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.integer(0), AbdVectorExpError)
  testthat::expect_error(entropart:::ShannonBeta.integer(0), AbdVectorExpError)
  testthat::expect_error(entropart:::SimpsonBeta.integer(0), AbdVectorExpError)
  testthat::expect_error(entropart:::TsallisBeta.integer(0), AbdVectorExpError)
  
  
  ProbaVectorError <- "An argument NorP or Ps must be provided."
  testthat::expect_error(entropart:::Diversity.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Dqz.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Hqz.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::HqzBeta.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::GenSimpson.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::GenSimpsonD.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Hurlbert.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::HurlbertD.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::PhyloDiversity.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::PhyloEntropy.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Rao.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Richness.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Shannon.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::ShannonBeta.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Simpson.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::SimpsonBeta.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::Tsallis.ProbaVector(), ProbaVectorError)
  testthat::expect_error(entropart:::TsallisBeta.ProbaVector(), ProbaVectorError)
  
  ProbaVectorExpError <- "An argument NorPexp or Pexp must be provided."
  testthat::expect_error(entropart:::HqzBeta.ProbaVector(0), ProbaVectorExpError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.ProbaVector(0), ProbaVectorExpError)
  testthat::expect_error(entropart:::ShannonBeta.ProbaVector(0), ProbaVectorExpError)
  testthat::expect_error(entropart:::SimpsonBeta.ProbaVector(0), ProbaVectorExpError)
  testthat::expect_error(entropart:::TsallisBeta.ProbaVector(0), ProbaVectorExpError)
  
  
  numericError <- "An argument NorP or Ps or Ns must be provided."
  testthat::expect_error(entropart:::Diversity.numeric(), numericError)
  testthat::expect_error(entropart:::Dqz.numeric(), numericError)
  testthat::expect_error(entropart:::Hqz.numeric(), numericError)
  testthat::expect_error(entropart:::HqzBeta.numeric(), numericError)
  testthat::expect_error(entropart:::GenSimpson.numeric(), numericError)
  testthat::expect_error(entropart:::GenSimpsonD.numeric(), numericError)
  testthat::expect_error(entropart:::Hurlbert.numeric(), numericError)
  testthat::expect_error(entropart:::HurlbertD.numeric(), numericError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.numeric(), numericError)
  testthat::expect_error(entropart:::PhyloDiversity.numeric(), numericError)
  testthat::expect_error(entropart:::PhyloEntropy.numeric(), numericError)
  testthat::expect_error(entropart:::Rao.numeric(), numericError)
  testthat::expect_error(entropart:::Richness.numeric(), numericError)
  testthat::expect_error(entropart:::Shannon.numeric(), numericError)
  testthat::expect_error(entropart:::ShannonBeta.numeric(), numericError)
  testthat::expect_error(entropart:::Simpson.numeric(), numericError)
  testthat::expect_error(entropart:::SimpsonBeta.numeric(), numericError)
  testthat::expect_error(entropart:::Tsallis.numeric(), numericError)
  testthat::expect_error(entropart:::TsallisBeta.numeric(), numericError)
  
  numericExpError <- "An argument NorPexp or Pexp or Nexp must be provided."
  testthat::expect_error(entropart:::HqzBeta.numeric(0), numericExpError)
  testthat::expect_error(entropart:::PhyloBetaEntropy.numeric(0), numericExpError)
  testthat::expect_error(entropart:::ShannonBeta.numeric(0), numericExpError)
  testthat::expect_error(entropart:::SimpsonBeta.numeric(0), numericExpError)
  testthat::expect_error(entropart:::TsallisBeta.numeric(0), numericExpError)
  
})
