% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibration}
\alias{calibration}
\alias{print.calibration}
\alias{plot.calibration}
\alias{lod}
\alias{loq}
\title{Analytical calibration functions}
\usage{
calibration(formula, data = NULL, model = "lm", ...)

\method{print}{calibration}(x, ...)

\method{plot}{calibration}(x, interval = NULL, level = 0.95, ...)

lod(x, alpha = 0.01, level = 0.05)

loq(x, alpha = 0.01, k = 3, level = 0.05, maxiter = 10)
}
\arguments{
\item{formula}{model formula providing the recorded signal intensities with
respect to the nominal analyte concentrations in the form of
\code{signal ~ concentration} or \code{signal ~ concentraion - 1}; model
formulae are currently restricted to those forms, however, the possibility
to use \code{log} or \code{sqrt} transformed data will be implemented in the
future}

\item{data}{an optional data frame containing the variables in the model}

\item{model}{model class to be used for fitting; currently,
\code{\link[stats]{lm}} and \code{\link[MASS]{rlm}} are supported}

\item{\dots}{further arguments passed to the sub method, i.e. the
respective model environment (e.g. \code{lm}), \code{plot}, or \code{print}}

\item{x}{an object of class \code{calibration} with a model formula
as shown above}

\item{interval}{Type of interval calculation (can be abbreviated); see
\code{\link[stats]{predict}} for details}

\item{level}{tolerance/confidence level; see \code{\link[stats]{predict}}
and \code{\link[stats]{confint}} for details}

\item{alpha}{error tolerance for the detection limit (critical value)}

\item{k}{relative uncertainty for the limit of quantification (1/beta)}

\item{maxiter}{a positive integer specifying the maximum number of iterations
to calculate the LOQ}
}
\value{
\code{calibration} returns an object of \code{\link[base]{class}}
"calibration". \code{print} calls the function parameters together with the
respective LOD and LOQ. \code{plot} plots the respective calibration curve
together with the measurement values. \code{summary} may be used to retrieve
the model parameters to be found as a list item called "model".
}
\description{
Defines a \code{calibration} object for the calculation of concentrations
from measurement signals including estimatations for the limit of detection
(LOD) and limit of quantification (LOQ) in accordance with DIN
32645:2008-11.

The LOD is defined as the lowest quantity of a substance that can be
distinguished from the absence of that substance (blank value) within a
given confidence level (alpha). The LOQ is defined as the lowest quantity of
a substance that can be quantified/distinguished from another sample given
with respect to a defined confidence level (k).
}
\details{
If the \code{data} supplied to \code{calibration} contain more than one blank
value, i.e. measurements with a nominal concentration of zero, the LOD and
LOQ are calculated from the deviation of the blank samples. This method is
called "blank method" according to DIN 32645:2008-11 and supposed to be more
accurate than the so-called "calibration method" which will be used for the
estimation of LOD and LOQ when \code{data} does not contain zero
concentration measurements.
}
\examples{
data(din32645)
din <- calibration(Area ~ Conc, data = din32645)
din
plot(din, interval = "confidence")
summary(din$model)

lod(din)

loq(din)

}
\references{
DIN 32645:2008-11, 2008. Chemical analysis - Decision limit, detection limit
and determination limit under repeatability conditions - Terms, methods,
evaluation (Technical standard). Deutsches Institut für Normung, Berlin.

Currie, L.A., 1999. Nomenclature in evaluation of analytical methods
including detection and quantification capabilities:
(IUPAC Recommendations 1995). Analytica Chimica Acta 391, 105–126.

Massart, D.L., Vandeginste, B.G., Buydens, L.M.C., Lewi, P.J.,
Smeyers-Verbeke, J., 1997. Handbook of chemometrics and qualimetrics:
Part A. Elsevier Science Inc.
}
\seealso{
\code{\link{icp}}, \code{\link{din32645}}
}
