% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amr_raw_to_metagenomeseq.R
\name{amr_raw_to_metagenomeseq}
\alias{amr_raw_to_metagenomeseq}
\title{Raw AMR files plus metadata to phyloseq object}
\arguments{
\item{path.to.amr.files}{path to folder containing raw CSV files from ARMA
CARD analysis}

\item{metadata}{data.table of metadata with "filename" and "barcode"
columns required}

\item{coveragenumber}{Minimum percentage of a gene that must be
covered. Range from 0 to 99, default = 80}

\item{keepSNP}{TRUE or FALSE: whether to keep AMR gene conferred by one SNP
change, default = FALSE}
}
\value{
metagenomeSeq object for downstream analysis
}
\description{
Given directory and metadata, make phyloseq object.
\pkg{\link{metagenomeSeq}} package required.
}
\examples{
\dontrun{
amr_raw_to_phyloseq(path.to.amr.files = path/to/amr.count.table,
metadata = metadata, coveragenumber = 80, keepSNP = FALSE)
}
}
\seealso{
\pkg{\link{metagenomeSeq}}
}
