% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pairwise.R
\name{get_pairwise}
\alias{get_pairwise}
\title{Characterise contacts by comparing case attributes}
\usage{
get_pairwise(x, attribute, f = NULL, hard_NA = TRUE)
}
\arguments{
\item{x}{an \code{\link{epicontacts}} object}

\item{attribute}{the attribute to be examined between contact pairs}

\item{f}{a function processing the attributes of 'from' and 'to'}

\item{hard_NA}{a logical indicating if the output should be NA whenever one
of the paired values is NA (TRUE, default); otherwise, 'NA' may be
treated as another character (e.g. when pasting paired values)}
}
\description{
This function extract attributes of cases involved in contacts using case
information provided in the linelist of an \code{\link{epicontacts}}
dataset. If not provided, the function used to process attributes will adjust
to the type of attribute selected (see details).
}
\examples{
if (require(outbreaks)) {
## example using MERS outbreak in Korea, 2014
head(mers_korea_2015[[1]])
head(mers_korea_2015[[2]])

x <- make_epicontacts(linelist=mers_korea_2015[[1]],
contacts=mers_korea_2015[[2]], directed=TRUE)

## estimate serial interval (onset->onset)
SI <- get_pairwise(x, "dt_onset")
SI
summary(SI)
hist(SI, col="grey", border="white", xlab="Days after symptoms",
     main="MERS Korea 2014 - Serial Interval")

## check gender mixing:
get_pairwise(x, "sex") # not good, we want 2-way table

get_pairwise(x, "sex", f=table) # use custom function
fisher.test(get_pairwise(x, "sex", f=table)) # test association
}
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
Tom Crellen (\email{tomcrellen@gmail.com})
}
