% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wages.r
\name{get_wages_by_education}
\alias{get_wages_by_education}
\title{Retreive the average hourly wages of workers disaggregated by the highest level of education attained}
\usage{
get_wages_by_education(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or character string with any combination of \code{g} (Gender) or
\code{r} (Race), i.e. if you want to retrieve
unemployment data by gender and race, you would set this parameter to "\code{gr}".}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
Wages by education are the average hourly wages of workers disaggregated by the highest
level of education attained. Employment shares provide the distribution of educational
attainment for workers of each gender, racial, and ethnic group as a share of total
employed for each group.
}
\examples{
get_wages_by_education()

get_wages_by_education("r")

get_wages_by_education("gr")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}

