% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_ecdc_ili}
\alias{pub_ecdc_ili}
\title{ECDC ILI data}
\usage{
pub_ecdc_ili(
  regions,
  epiweeks,
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Regions to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/ecdc_ili.html}.

Obtain information on influenza-like-illness from the European Centre for
Disease Prevention and Control.
}
\details{
The list of location argument can be found in
\url{https://github.com/cmu-delphi/delphi-epidata/blob/main/labels/ecdc_regions.txt}.
}
\examples{
\dontrun{
pub_ecdc_ili(regions = "austria", epiweeks = epirange(201901, 202001))
}
}
\keyword{endpoint}
