% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_covidcast}
\alias{pub_covidcast}
\title{Various COVID and flu signals via the COVIDcast endpoint}
\usage{
pub_covidcast(
  source,
  signals,
  geo_type,
  time_type,
  geo_values = "*",
  time_values = "*",
  ...,
  as_of = NULL,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{source}{string. The data source to query (see:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}).}

\item{signals}{string. The signals to query from a specific source (see:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}).}

\item{geo_type}{string. The geographic resolution of the data (see:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_geography.html}).}

\item{time_type}{string. The temporal resolution of the data (either "day" or
"week", depending on signal).}

\item{geo_values}{character. The geographies to return. "*" fetches
all. (See:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_geography.html}.)}

\item{time_values}{\code{\link{timeset}}. Dates to fetch. Defaults to all ("*") dates.}

\item{...}{not used for values, forces later arguments to bind by name}

\item{as_of}{Date. Optionally, the as of date for the issues to fetch. If not
specified, the most recent data is returned. Mutually exclusive with
\code{issues} or \code{lag}.}

\item{issues}{\code{\link{timeset}}. Optionally, the issue of the data to fetch. If not
specified, the most recent issue is returned. Mutually exclusive with
\code{as_of} or \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{as_of} or
\code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/covidcast_signals.html}

The primary endpoint for fetching COVID-19 data, providing access to a wide
variety of signals from a wide variety of sources. See the API documentation
link above for more. Delphi's \href{https://delphi.cmu.edu/covidcast/}{COVIDcast public dashboard} is powered by this endpoint.
}
\examples{
\dontrun{
pub_covidcast(
  source = "jhu-csse",
  signals = "confirmed_7dav_incidence_prop",
  geo_type = "state",
  time_type = "day",
  geo_values = c("ca", "fl"),
  time_values = epirange(20200601, 20200801)
)
pub_covidcast(
  source = "jhu-csse",
  signals = "confirmed_7dav_incidence_prop",
  geo_type = "state",
  time_type = "day",
  geo_values = "*",
  time_values = epirange(20200601, 20200801)
)
}

}
\seealso{
\code{\link[=pub_covidcast_meta]{pub_covidcast_meta()}}, \code{\link[=covidcast_epidata]{covidcast_epidata()}}, \code{\link[=epirange]{epirange()}}
}
\keyword{endpoint}
