// Generated by rstantools.  Do not edit by hand.

/*
    epidemia is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    epidemia is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with epidemia.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_epidemia_pp_base_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_epidemia_pp_base");
    reader.add_event(1, 1, "include", "functions/reverse.stan");
    reader.add_event(1, 0, "start", "functions/reverse.stan");
    reader.add_event(10, 9, "end", "functions/reverse.stan");
    reader.add_event(10, 2, "restart", "model_epidemia_pp_base");
    reader.add_event(10, 2, "include", "functions/linkinv.stan");
    reader.add_event(10, 0, "start", "functions/linkinv.stan");
    reader.add_event(27, 17, "end", "functions/linkinv.stan");
    reader.add_event(27, 3, "restart", "model_epidemia_pp_base");
    reader.add_event(27, 3, "include", "functions/trunc_normal.stan");
    reader.add_event(27, 0, "start", "functions/trunc_normal.stan");
    reader.add_event(33, 6, "end", "functions/trunc_normal.stan");
    reader.add_event(33, 4, "restart", "model_epidemia_pp_base");
    reader.add_event(36, 7, "include", "data/data_indices.stan");
    reader.add_event(36, 0, "start", "data/data_indices.stan");
    reader.add_event(46, 10, "end", "data/data_indices.stan");
    reader.add_event(46, 8, "restart", "model_epidemia_pp_base");
    reader.add_event(46, 8, "include", "data/data_obs.stan");
    reader.add_event(46, 0, "start", "data/data_obs.stan");
    reader.add_event(66, 20, "end", "data/data_obs.stan");
    reader.add_event(66, 9, "restart", "model_epidemia_pp_base");
    reader.add_event(66, 9, "include", "data/data_model.stan");
    reader.add_event(66, 0, "start", "data/data_model.stan");
    reader.add_event(73, 7, "end", "data/data_model.stan");
    reader.add_event(73, 10, "restart", "model_epidemia_pp_base");
    reader.add_event(73, 10, "include", "/data/data_inf.stan");
    reader.add_event(73, 0, "start", "/data/data_inf.stan");
    reader.add_event(79, 6, "end", "/data/data_inf.stan");
    reader.add_event(79, 11, "restart", "model_epidemia_pp_base");
    reader.add_event(82, 14, "include", "tdata/tdata_reverse.stan");
    reader.add_event(82, 0, "start", "tdata/tdata_reverse.stan");
    reader.add_event(86, 4, "end", "tdata/tdata_reverse.stan");
    reader.add_event(86, 15, "restart", "model_epidemia_pp_base");
    reader.add_event(105, 34, "include", "/tparameters/infections_rt.stan");
    reader.add_event(105, 0, "start", "/tparameters/infections_rt.stan");
    reader.add_event(110, 5, "end", "/tparameters/infections_rt.stan");
    reader.add_event(110, 35, "restart", "model_epidemia_pp_base");
    reader.add_event(110, 35, "include", "/generated_quantities/gen_infections_pp.stan");
    reader.add_event(110, 0, "start", "/generated_quantities/gen_infections_pp.stan");
    reader.add_event(167, 57, "end", "/generated_quantities/gen_infections_pp.stan");
    reader.add_event(167, 36, "restart", "model_epidemia_pp_base");
    reader.add_event(167, 36, "include", "/tparameters/gen_eobs.stan");
    reader.add_event(167, 0, "start", "/tparameters/gen_eobs.stan");
    reader.add_event(189, 22, "end", "/tparameters/gen_eobs.stan");
    reader.add_event(189, 37, "restart", "model_epidemia_pp_base");
    reader.add_event(202, 48, "end", "model_epidemia_pp_base");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
reverse2(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(vec));
        current_statement_begin__ = 4;
        validate_non_negative_index("rev", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rev(K);
        stan::math::initialize(rev, DUMMY_VAR__);
        stan::math::fill(rev, DUMMY_VAR__);
        current_statement_begin__ = 5;
        for (int k = 1; k <= K; ++k) {
            current_statement_begin__ = 6;
            stan::model::assign(rev, 
                        stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                        get_base1(vec, ((K - k) + 1), "vec", 1), 
                        "assigning variable rev");
        }
        current_statement_begin__ = 8;
        return stan::math::promote_scalar<fun_return_scalar_t__>(rev);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reverse2_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec, std::ostream* pstream__) const {
        return reverse2(vec, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
linkinv(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
            const int& link, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 20;
        if (as_bool(logical_eq(link, 1))) {
            current_statement_begin__ = 20;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_logit(eta));
        } else if (as_bool(logical_eq(link, 2))) {
            current_statement_begin__ = 21;
            return stan::math::promote_scalar<fun_return_scalar_t__>(Phi(eta));
        } else if (as_bool(logical_eq(link, 3))) {
            current_statement_begin__ = 22;
            return stan::math::promote_scalar<fun_return_scalar_t__>(add(divide(stan::math::atan(eta), stan::math::pi()), 0.5));
        } else if (as_bool(logical_eq(link, 4))) {
            current_statement_begin__ = 23;
            return stan::math::promote_scalar<fun_return_scalar_t__>(inv_cloglog(eta));
        } else if (as_bool(logical_eq(link, 5))) {
            current_statement_begin__ = 24;
            return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
        } else {
            current_statement_begin__ = 25;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Invalid link";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 26;
        return stan::math::promote_scalar<fun_return_scalar_t__>(eta);
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct linkinv_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& eta,
            const int& link, std::ostream* pstream__) const {
        return linkinv(eta, link, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, class RNG>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
normal_lb_rng(const T0__& mu,
                  const T1__& sigma,
                  const T2__& lb, RNG& base_rng__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 29;
        local_scalar_t__ p_lb(DUMMY_VAR__);
        (void) p_lb;  // dummy to suppress unused var warning
        stan::math::initialize(p_lb, DUMMY_VAR__);
        stan::math::fill(p_lb, DUMMY_VAR__);
        stan::math::assign(p_lb,normal_cdf(lb, mu, sigma));
        current_statement_begin__ = 30;
        local_scalar_t__ u(DUMMY_VAR__);
        (void) u;  // dummy to suppress unused var warning
        stan::math::initialize(u, DUMMY_VAR__);
        stan::math::fill(u, DUMMY_VAR__);
        stan::math::assign(u,uniform_rng(p_lb, 1.0, base_rng__));
        current_statement_begin__ = 31;
        local_scalar_t__ y(DUMMY_VAR__);
        (void) y;  // dummy to suppress unused var warning
        stan::math::initialize(y, DUMMY_VAR__);
        stan::math::fill(y, DUMMY_VAR__);
        stan::math::assign(y,(mu + (sigma * inv_Phi(u))));
        current_statement_begin__ = 32;
        return stan::math::promote_scalar<fun_return_scalar_t__>(y);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct normal_lb_rng_functor__ {
    template <typename T0__, typename T1__, typename T2__, class RNG>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& mu,
                  const T1__& sigma,
                  const T2__& lb, RNG& base_rng__, std::ostream* pstream__) const {
        return normal_lb_rng(mu, sigma, lb, base_rng__, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_epidemia_pp_base
  : public stan::model::model_base_crtp<model_epidemia_pp_base> {
private:
        int M;
        int N0;
        std::vector<int> starts;
        std::vector<int> NC;
        int N;
        int N2;
        int NS;
        int N_obs;
        std::vector<int> obs_group;
        std::vector<int> obs_type;
        std::vector<int> obs_date;
        int R;
        std::vector<int> oN;
        std::vector<int> pvecs_len;
        std::vector<vector_d> pvecs;
        std::vector<int> has_offset;
        vector_d offset_;
        std::vector<int> ofamily;
        std::vector<int> olink;
        int num_oaux;
        std::vector<int> has_oaux;
        double carry;
        int link;
        matrix_d vacc;
        std::vector<double> pops;
        int gen_len;
        vector_d gen;
        int pop_adjust;
        int hseeds;
        int latent;
        int inf_family;
        int S0_fixed;
        int veps_fixed;
        int fixed_vtm;
        vector_d gen_rev;
        std::vector<vector_d> pvecs_rev;
public:
    model_epidemia_pp_base(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_epidemia_pp_base(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_epidemia_pp_base_namespace::model_epidemia_pp_base";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "M", "int", context__.to_vec());
            M = int(0);
            vals_i__ = context__.vals_i("M");
            pos__ = 0;
            M = vals_i__[pos__++];
            check_greater_or_equal(function__, "M", M, 1);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "N0", "int", context__.to_vec());
            N0 = int(0);
            vals_i__ = context__.vals_i("N0");
            pos__ = 0;
            N0 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N0", N0, 1);
            current_statement_begin__ = 40;
            validate_non_negative_index("starts", "M", M);
            context__.validate_dims("data initialization", "starts", "int", context__.to_vec(M));
            starts = std::vector<int>(M, int(0));
            vals_i__ = context__.vals_i("starts");
            pos__ = 0;
            size_t starts_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < starts_k_0_max__; ++k_0__) {
                starts[k_0__] = vals_i__[pos__++];
            }
            size_t starts_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < starts_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "starts[i_0__]", starts[i_0__], 1);
            }
            current_statement_begin__ = 41;
            validate_non_negative_index("NC", "M", M);
            context__.validate_dims("data initialization", "NC", "int", context__.to_vec(M));
            NC = std::vector<int>(M, int(0));
            vals_i__ = context__.vals_i("NC");
            pos__ = 0;
            size_t NC_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < NC_k_0_max__; ++k_0__) {
                NC[k_0__] = vals_i__[pos__++];
            }
            size_t NC_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < NC_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "NC[i_0__]", NC[i_0__], 1);
            }
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "N2", "int", context__.to_vec());
            N2 = int(0);
            vals_i__ = context__.vals_i("N2");
            pos__ = 0;
            N2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N2", N2, 1);
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "NS", "int", context__.to_vec());
            NS = int(0);
            vals_i__ = context__.vals_i("NS");
            pos__ = 0;
            NS = vals_i__[pos__++];
            check_greater_or_equal(function__, "NS", NS, 1);
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "N_obs", "int", context__.to_vec());
            N_obs = int(0);
            vals_i__ = context__.vals_i("N_obs");
            pos__ = 0;
            N_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_obs", N_obs, 0);
            current_statement_begin__ = 48;
            validate_non_negative_index("obs_group", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_group", "int", context__.to_vec(N_obs));
            obs_group = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_group");
            pos__ = 0;
            size_t obs_group_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_group_k_0_max__; ++k_0__) {
                obs_group[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 49;
            validate_non_negative_index("obs_type", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_type", "int", context__.to_vec(N_obs));
            obs_type = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_type");
            pos__ = 0;
            size_t obs_type_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_type_k_0_max__; ++k_0__) {
                obs_type[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 50;
            validate_non_negative_index("obs_date", "N_obs", N_obs);
            context__.validate_dims("data initialization", "obs_date", "int", context__.to_vec(N_obs));
            obs_date = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("obs_date");
            pos__ = 0;
            size_t obs_date_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < obs_date_k_0_max__; ++k_0__) {
                obs_date[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 52;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            check_greater_or_equal(function__, "R", R, 0);
            current_statement_begin__ = 53;
            validate_non_negative_index("oN", "10", 10);
            context__.validate_dims("data initialization", "oN", "int", context__.to_vec(10));
            oN = std::vector<int>(10, int(0));
            vals_i__ = context__.vals_i("oN");
            pos__ = 0;
            size_t oN_k_0_max__ = 10;
            for (size_t k_0__ = 0; k_0__ < oN_k_0_max__; ++k_0__) {
                oN[k_0__] = vals_i__[pos__++];
            }
            size_t oN_i_0_max__ = 10;
            for (size_t i_0__ = 0; i_0__ < oN_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "oN[i_0__]", oN[i_0__], 0);
            }
            current_statement_begin__ = 54;
            validate_non_negative_index("pvecs_len", "R", R);
            context__.validate_dims("data initialization", "pvecs_len", "int", context__.to_vec(R));
            pvecs_len = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("pvecs_len");
            pos__ = 0;
            size_t pvecs_len_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < pvecs_len_k_0_max__; ++k_0__) {
                pvecs_len[k_0__] = vals_i__[pos__++];
            }
            size_t pvecs_len_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_len_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs_len[i_0__]", pvecs_len[i_0__], 1);
            }
            current_statement_begin__ = 55;
            validate_non_negative_index("pvecs", "NS", NS);
            validate_non_negative_index("pvecs", "R", R);
            context__.validate_dims("data initialization", "pvecs", "vector_d", context__.to_vec(R,NS));
            pvecs = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(R, Eigen::Matrix<double, Eigen::Dynamic, 1>(NS));
            vals_r__ = context__.vals_r("pvecs");
            pos__ = 0;
            size_t pvecs_j_1_max__ = NS;
            size_t pvecs_k_0_max__ = R;
            for (size_t j_1__ = 0; j_1__ < pvecs_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < pvecs_k_0_max__; ++k_0__) {
                    pvecs[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            size_t pvecs_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs[i_0__]", pvecs[i_0__], 0);
            }
            current_statement_begin__ = 57;
            validate_non_negative_index("has_offset", "R", R);
            context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec(R));
            has_offset = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("has_offset");
            pos__ = 0;
            size_t has_offset_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < has_offset_k_0_max__; ++k_0__) {
                has_offset[k_0__] = vals_i__[pos__++];
            }
            size_t has_offset_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < has_offset_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "has_offset[i_0__]", has_offset[i_0__], 0);
                check_less_or_equal(function__, "has_offset[i_0__]", has_offset[i_0__], 1);
            }
            current_statement_begin__ = 58;
            validate_non_negative_index("offset_", "N_obs", N_obs);
            context__.validate_dims("data initialization", "offset_", "vector_d", context__.to_vec(N_obs));
            offset_ = Eigen::Matrix<double, Eigen::Dynamic, 1>(N_obs);
            vals_r__ = context__.vals_r("offset_");
            pos__ = 0;
            size_t offset__j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < offset__j_1_max__; ++j_1__) {
                offset_(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 61;
            validate_non_negative_index("ofamily", "R", R);
            context__.validate_dims("data initialization", "ofamily", "int", context__.to_vec(R));
            ofamily = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("ofamily");
            pos__ = 0;
            size_t ofamily_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < ofamily_k_0_max__; ++k_0__) {
                ofamily[k_0__] = vals_i__[pos__++];
            }
            size_t ofamily_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < ofamily_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ofamily[i_0__]", ofamily[i_0__], 1);
                check_less_or_equal(function__, "ofamily[i_0__]", ofamily[i_0__], 5);
            }
            current_statement_begin__ = 62;
            validate_non_negative_index("olink", "R", R);
            context__.validate_dims("data initialization", "olink", "int", context__.to_vec(R));
            olink = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("olink");
            pos__ = 0;
            size_t olink_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < olink_k_0_max__; ++k_0__) {
                olink[k_0__] = vals_i__[pos__++];
            }
            size_t olink_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < olink_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "olink[i_0__]", olink[i_0__], 1);
                check_less_or_equal(function__, "olink[i_0__]", olink[i_0__], 5);
            }
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "num_oaux", "int", context__.to_vec());
            num_oaux = int(0);
            vals_i__ = context__.vals_i("num_oaux");
            pos__ = 0;
            num_oaux = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_oaux", num_oaux, 0);
            current_statement_begin__ = 66;
            validate_non_negative_index("has_oaux", "R", R);
            context__.validate_dims("data initialization", "has_oaux", "int", context__.to_vec(R));
            has_oaux = std::vector<int>(R, int(0));
            vals_i__ = context__.vals_i("has_oaux");
            pos__ = 0;
            size_t has_oaux_k_0_max__ = R;
            for (size_t k_0__ = 0; k_0__ < has_oaux_k_0_max__; ++k_0__) {
                has_oaux[k_0__] = vals_i__[pos__++];
            }
            size_t has_oaux_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < has_oaux_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "has_oaux[i_0__]", has_oaux[i_0__], 0);
                check_less_or_equal(function__, "has_oaux[i_0__]", has_oaux[i_0__], num_oaux);
            }
            current_statement_begin__ = 67;
            context__.validate_dims("data initialization", "carry", "double", context__.to_vec());
            carry = double(0);
            vals_r__ = context__.vals_r("carry");
            pos__ = 0;
            carry = vals_r__[pos__++];
            check_greater_or_equal(function__, "carry", carry, 0);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            check_less_or_equal(function__, "link", link, 3);
            current_statement_begin__ = 69;
            validate_non_negative_index("vacc", "N2", N2);
            validate_non_negative_index("vacc", "M", M);
            context__.validate_dims("data initialization", "vacc", "matrix_d", context__.to_vec(N2,M));
            vacc = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N2, M);
            vals_r__ = context__.vals_r("vacc");
            pos__ = 0;
            size_t vacc_j_2_max__ = M;
            size_t vacc_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < vacc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < vacc_j_1_max__; ++j_1__) {
                    vacc(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "vacc", vacc, 0);
            check_less_or_equal(function__, "vacc", vacc, 1);
            current_statement_begin__ = 70;
            validate_non_negative_index("pops", "M", M);
            context__.validate_dims("data initialization", "pops", "double", context__.to_vec(M));
            pops = std::vector<double>(M, double(0));
            vals_r__ = context__.vals_r("pops");
            pos__ = 0;
            size_t pops_k_0_max__ = M;
            for (size_t k_0__ = 0; k_0__ < pops_k_0_max__; ++k_0__) {
                pops[k_0__] = vals_r__[pos__++];
            }
            size_t pops_i_0_max__ = M;
            for (size_t i_0__ = 0; i_0__ < pops_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pops[i_0__]", pops[i_0__], 0);
            }
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "gen_len", "int", context__.to_vec());
            gen_len = int(0);
            vals_i__ = context__.vals_i("gen_len");
            pos__ = 0;
            gen_len = vals_i__[pos__++];
            check_greater_or_equal(function__, "gen_len", gen_len, 1);
            current_statement_begin__ = 72;
            validate_non_negative_index("gen", "gen_len", gen_len);
            context__.validate_dims("data initialization", "gen", "vector_d", context__.to_vec(gen_len));
            gen = Eigen::Matrix<double, Eigen::Dynamic, 1>(gen_len);
            vals_r__ = context__.vals_r("gen");
            pos__ = 0;
            size_t gen_j_1_max__ = gen_len;
            for (size_t j_1__ = 0; j_1__ < gen_j_1_max__; ++j_1__) {
                gen(j_1__) = vals_r__[pos__++];
            }
            stan::math::check_simplex(function__, "gen", gen);
            current_statement_begin__ = 73;
            context__.validate_dims("data initialization", "pop_adjust", "int", context__.to_vec());
            pop_adjust = int(0);
            vals_i__ = context__.vals_i("pop_adjust");
            pos__ = 0;
            pop_adjust = vals_i__[pos__++];
            check_greater_or_equal(function__, "pop_adjust", pop_adjust, 0);
            check_less_or_equal(function__, "pop_adjust", pop_adjust, 1);
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "hseeds", "int", context__.to_vec());
            hseeds = int(0);
            vals_i__ = context__.vals_i("hseeds");
            pos__ = 0;
            hseeds = vals_i__[pos__++];
            check_greater_or_equal(function__, "hseeds", hseeds, 0);
            check_less_or_equal(function__, "hseeds", hseeds, 1);
            current_statement_begin__ = 75;
            context__.validate_dims("data initialization", "latent", "int", context__.to_vec());
            latent = int(0);
            vals_i__ = context__.vals_i("latent");
            pos__ = 0;
            latent = vals_i__[pos__++];
            check_greater_or_equal(function__, "latent", latent, 0);
            check_less_or_equal(function__, "latent", latent, 1);
            current_statement_begin__ = 76;
            context__.validate_dims("data initialization", "inf_family", "int", context__.to_vec());
            inf_family = int(0);
            vals_i__ = context__.vals_i("inf_family");
            pos__ = 0;
            inf_family = vals_i__[pos__++];
            check_greater_or_equal(function__, "inf_family", inf_family, 0);
            check_less_or_equal(function__, "inf_family", inf_family, 1);
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "S0_fixed", "int", context__.to_vec());
            S0_fixed = int(0);
            vals_i__ = context__.vals_i("S0_fixed");
            pos__ = 0;
            S0_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "S0_fixed", S0_fixed, 0);
            check_less_or_equal(function__, "S0_fixed", S0_fixed, 1);
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "veps_fixed", "int", context__.to_vec());
            veps_fixed = int(0);
            vals_i__ = context__.vals_i("veps_fixed");
            pos__ = 0;
            veps_fixed = vals_i__[pos__++];
            check_greater_or_equal(function__, "veps_fixed", veps_fixed, 0);
            check_less_or_equal(function__, "veps_fixed", veps_fixed, 1);
            current_statement_begin__ = 79;
            context__.validate_dims("data initialization", "fixed_vtm", "int", context__.to_vec());
            fixed_vtm = int(0);
            vals_i__ = context__.vals_i("fixed_vtm");
            pos__ = 0;
            fixed_vtm = vals_i__[pos__++];
            check_greater_or_equal(function__, "fixed_vtm", fixed_vtm, 0);
            check_less_or_equal(function__, "fixed_vtm", fixed_vtm, 1);
            // initialize transformed data variables
            current_statement_begin__ = 84;
            validate_non_negative_index("gen_rev", "gen_len", gen_len);
            gen_rev = Eigen::Matrix<double, Eigen::Dynamic, 1>(gen_len);
            stan::math::fill(gen_rev, DUMMY_VAR__);
            stan::math::assign(gen_rev,reverse2(gen, pstream__));
            current_statement_begin__ = 85;
            validate_non_negative_index("pvecs_rev", "NS", NS);
            validate_non_negative_index("pvecs_rev", "R", R);
            pvecs_rev = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(R, Eigen::Matrix<double, Eigen::Dynamic, 1>(NS));
            stan::math::fill(pvecs_rev, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 88;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 89;
                stan::model::assign(pvecs_rev, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list()), 
                            reverse2(get_base1(pvecs, r, "pvecs", 1), pstream__), 
                            "assigning variable pvecs_rev");
            }
            // validate transformed data
            current_statement_begin__ = 84;
            stan::math::check_simplex(function__, "gen_rev", gen_rev);
            current_statement_begin__ = 85;
            size_t pvecs_rev_i_0_max__ = R;
            for (size_t i_0__ = 0; i_0__ < pvecs_rev_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pvecs_rev[i_0__]", pvecs_rev[i_0__], 0);
            }
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 93;
            validate_non_negative_index("seeds", "(M + 2)", (M + 2));
            num_params_r__ += (M + 2);
            current_statement_begin__ = 94;
            validate_non_negative_index("oaux", "(num_oaux + 2)", (num_oaux + 2));
            num_params_r__ += (num_oaux + 2);
            current_statement_begin__ = 95;
            validate_non_negative_index("eta", "(N + 2)", (N + 2));
            num_params_r__ += (N + 2);
            current_statement_begin__ = 96;
            validate_non_negative_index("oeta", "(N_obs + 2)", (N_obs + 2));
            num_params_r__ += (N_obs + 2);
            current_statement_begin__ = 97;
            validate_non_negative_index("infections_raw", "(latent ? ((N - (M * N0)) + 2) : 2 )", (latent ? ((N - (M * N0)) + 2) : 2 ));
            num_params_r__ += (latent ? ((N - (M * N0)) + 2) : 2 );
            current_statement_begin__ = 98;
            validate_non_negative_index("inf_aux", "(latent ? 3 : 2 )", (latent ? 3 : 2 ));
            num_params_r__ += (latent ? 3 : 2 );
            current_statement_begin__ = 99;
            validate_non_negative_index("S0", "(S0_fixed ? 2 : (M + 2) )", (S0_fixed ? 2 : (M + 2) ));
            num_params_r__ += (S0_fixed ? 2 : (M + 2) );
            current_statement_begin__ = 100;
            validate_non_negative_index("veps", "(veps_fixed ? 2 : (M + 2) )", (veps_fixed ? 2 : (M + 2) ));
            num_params_r__ += (veps_fixed ? 2 : (M + 2) );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_epidemia_pp_base() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 93;
        if (!(context__.contains_r("seeds")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable seeds missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("seeds");
        pos__ = 0U;
        validate_non_negative_index("seeds", "(M + 2)", (M + 2));
        context__.validate_dims("parameter initialization", "seeds", "vector_d", context__.to_vec((M + 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds((M + 2));
        size_t seeds_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
            seeds(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, seeds);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable seeds: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 94;
        if (!(context__.contains_r("oaux")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable oaux missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("oaux");
        pos__ = 0U;
        validate_non_negative_index("oaux", "(num_oaux + 2)", (num_oaux + 2));
        context__.validate_dims("parameter initialization", "oaux", "vector_d", context__.to_vec((num_oaux + 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> oaux((num_oaux + 2));
        size_t oaux_j_1_max__ = (num_oaux + 2);
        for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
            oaux(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, oaux);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable oaux: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 95;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        validate_non_negative_index("eta", "(N + 2)", (N + 2));
        context__.validate_dims("parameter initialization", "eta", "vector_d", context__.to_vec((N + 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta((N + 2));
        size_t eta_j_1_max__ = (N + 2);
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            eta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 96;
        if (!(context__.contains_r("oeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable oeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("oeta");
        pos__ = 0U;
        validate_non_negative_index("oeta", "(N_obs + 2)", (N_obs + 2));
        context__.validate_dims("parameter initialization", "oeta", "vector_d", context__.to_vec((N_obs + 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> oeta((N_obs + 2));
        size_t oeta_j_1_max__ = (N_obs + 2);
        for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
            oeta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(oeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable oeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 97;
        if (!(context__.contains_r("infections_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable infections_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("infections_raw");
        pos__ = 0U;
        validate_non_negative_index("infections_raw", "(latent ? ((N - (M * N0)) + 2) : 2 )", (latent ? ((N - (M * N0)) + 2) : 2 ));
        context__.validate_dims("parameter initialization", "infections_raw", "vector_d", context__.to_vec((latent ? ((N - (M * N0)) + 2) : 2 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> infections_raw((latent ? ((N - (M * N0)) + 2) : 2 ));
        size_t infections_raw_j_1_max__ = (latent ? ((N - (M * N0)) + 2) : 2 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            infections_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(-(1), infections_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable infections_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 98;
        if (!(context__.contains_r("inf_aux")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable inf_aux missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("inf_aux");
        pos__ = 0U;
        validate_non_negative_index("inf_aux", "(latent ? 3 : 2 )", (latent ? 3 : 2 ));
        context__.validate_dims("parameter initialization", "inf_aux", "vector_d", context__.to_vec((latent ? 3 : 2 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> inf_aux((latent ? 3 : 2 ));
        size_t inf_aux_j_1_max__ = (latent ? 3 : 2 );
        for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
            inf_aux(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, inf_aux);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable inf_aux: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 99;
        if (!(context__.contains_r("S0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable S0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("S0");
        pos__ = 0U;
        validate_non_negative_index("S0", "(S0_fixed ? 2 : (M + 2) )", (S0_fixed ? 2 : (M + 2) ));
        context__.validate_dims("parameter initialization", "S0", "vector_d", context__.to_vec((S0_fixed ? 2 : (M + 2) )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> S0((S0_fixed ? 2 : (M + 2) ));
        size_t S0_j_1_max__ = (S0_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            S0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, S0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable S0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 100;
        if (!(context__.contains_r("veps")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable veps missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("veps");
        pos__ = 0U;
        validate_non_negative_index("veps", "(veps_fixed ? 2 : (M + 2) )", (veps_fixed ? 2 : (M + 2) ));
        context__.validate_dims("parameter initialization", "veps", "vector_d", context__.to_vec((veps_fixed ? 2 : (M + 2) )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> veps((veps_fixed ? 2 : (M + 2) ));
        size_t veps_j_1_max__ = (veps_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            veps(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, veps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable veps: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 93;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> seeds;
            (void) seeds;  // dummy to suppress unused var warning
            if (jacobian__)
                seeds = in__.vector_lb_constrain(0, (M + 2), lp__);
            else
                seeds = in__.vector_lb_constrain(0, (M + 2));
            current_statement_begin__ = 94;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oaux;
            (void) oaux;  // dummy to suppress unused var warning
            if (jacobian__)
                oaux = in__.vector_lb_constrain(0, (num_oaux + 2), lp__);
            else
                oaux = in__.vector_lb_constrain(0, (num_oaux + 2));
            current_statement_begin__ = 95;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.vector_constrain((N + 2), lp__);
            else
                eta = in__.vector_constrain((N + 2));
            current_statement_begin__ = 96;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> oeta;
            (void) oeta;  // dummy to suppress unused var warning
            if (jacobian__)
                oeta = in__.vector_constrain((N_obs + 2), lp__);
            else
                oeta = in__.vector_constrain((N_obs + 2));
            current_statement_begin__ = 97;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> infections_raw;
            (void) infections_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                infections_raw = in__.vector_lb_constrain(-(1), (latent ? ((N - (M * N0)) + 2) : 2 ), lp__);
            else
                infections_raw = in__.vector_lb_constrain(-(1), (latent ? ((N - (M * N0)) + 2) : 2 ));
            current_statement_begin__ = 98;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> inf_aux;
            (void) inf_aux;  // dummy to suppress unused var warning
            if (jacobian__)
                inf_aux = in__.vector_lb_constrain(0, (latent ? 3 : 2 ), lp__);
            else
                inf_aux = in__.vector_lb_constrain(0, (latent ? 3 : 2 ));
            current_statement_begin__ = 99;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> S0;
            (void) S0;  // dummy to suppress unused var warning
            if (jacobian__)
                S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 2 : (M + 2) ), lp__);
            else
                S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 2 : (M + 2) ));
            current_statement_begin__ = 100;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> veps;
            (void) veps;  // dummy to suppress unused var warning
            if (jacobian__)
                veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 2 : (M + 2) ), lp__);
            else
                veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 2 : (M + 2) ));
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("seeds");
        names__.push_back("oaux");
        names__.push_back("eta");
        names__.push_back("oeta");
        names__.push_back("infections_raw");
        names__.push_back("inf_aux");
        names__.push_back("S0");
        names__.push_back("veps");
        names__.push_back("E_obs");
        names__.push_back("Rt");
        names__.push_back("infectiousness");
        names__.push_back("Rt_unadj");
        names__.push_back("load");
        names__.push_back("E_infections");
        names__.push_back("infections");
        names__.push_back("susc");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((M + 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((num_oaux + 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((N + 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((N_obs + 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((latent ? ((N - (M * N0)) + 2) : 2 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((latent ? 3 : 2 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((S0_fixed ? 2 : (M + 2) ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((veps_fixed ? 2 : (M + 2) ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_obs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N2);
        dims__.push_back(M);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_epidemia_pp_base_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> seeds = in__.vector_lb_constrain(0, (M + 2));
        size_t seeds_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
            vars__.push_back(seeds(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> oaux = in__.vector_lb_constrain(0, (num_oaux + 2));
        size_t oaux_j_1_max__ = (num_oaux + 2);
        for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
            vars__.push_back(oaux(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eta = in__.vector_constrain((N + 2));
        size_t eta_j_1_max__ = (N + 2);
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            vars__.push_back(eta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> oeta = in__.vector_constrain((N_obs + 2));
        size_t oeta_j_1_max__ = (N_obs + 2);
        for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
            vars__.push_back(oeta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> infections_raw = in__.vector_lb_constrain(-(1), (latent ? ((N - (M * N0)) + 2) : 2 ));
        size_t infections_raw_j_1_max__ = (latent ? ((N - (M * N0)) + 2) : 2 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            vars__.push_back(infections_raw(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> inf_aux = in__.vector_lb_constrain(0, (latent ? 3 : 2 ));
        size_t inf_aux_j_1_max__ = (latent ? 3 : 2 );
        for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
            vars__.push_back(inf_aux(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> S0 = in__.vector_lub_constrain(0, 1, (S0_fixed ? 2 : (M + 2) ));
        size_t S0_j_1_max__ = (S0_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            vars__.push_back(S0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> veps = in__.vector_lub_constrain(0, 1, (veps_fixed ? 2 : (M + 2) ));
        size_t veps_j_1_max__ = (veps_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            vars__.push_back(veps(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 103;
            validate_non_negative_index("E_obs", "N_obs", N_obs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> E_obs(N_obs);
            stan::math::initialize(E_obs, DUMMY_VAR__);
            stan::math::fill(E_obs, DUMMY_VAR__);
            current_statement_begin__ = 104;
            validate_non_negative_index("Rt", "N2", N2);
            validate_non_negative_index("Rt", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Rt(N2, M);
            stan::math::initialize(Rt, DUMMY_VAR__);
            stan::math::fill(Rt, DUMMY_VAR__);
            stan::math::assign(Rt,rep_matrix(0, N2, M));
            current_statement_begin__ = 105;
            validate_non_negative_index("infectiousness", "N2", N2);
            validate_non_negative_index("infectiousness", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> infectiousness(N2, M);
            stan::math::initialize(infectiousness, DUMMY_VAR__);
            stan::math::fill(infectiousness, DUMMY_VAR__);
            current_statement_begin__ = 106;
            validate_non_negative_index("Rt_unadj", "N2", N2);
            validate_non_negative_index("Rt_unadj", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Rt_unadj(N2, M);
            stan::math::initialize(Rt_unadj, DUMMY_VAR__);
            stan::math::fill(Rt_unadj, DUMMY_VAR__);
            stan::math::assign(Rt_unadj,rep_matrix(0, N2, M));
            current_statement_begin__ = 107;
            validate_non_negative_index("load", "N2", N2);
            validate_non_negative_index("load", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> load(N2, M);
            stan::math::initialize(load, DUMMY_VAR__);
            stan::math::fill(load, DUMMY_VAR__);
            stan::math::assign(load,rep_matrix(0, N2, M));
            current_statement_begin__ = 108;
            validate_non_negative_index("E_infections", "N2", N2);
            validate_non_negative_index("E_infections", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> E_infections(N2, M);
            stan::math::initialize(E_infections, DUMMY_VAR__);
            stan::math::fill(E_infections, DUMMY_VAR__);
            stan::math::assign(E_infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 109;
            validate_non_negative_index("infections", "N2", N2);
            validate_non_negative_index("infections", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> infections(N2, M);
            stan::math::initialize(infections, DUMMY_VAR__);
            stan::math::fill(infections, DUMMY_VAR__);
            stan::math::assign(infections,rep_matrix(0, N2, M));
            current_statement_begin__ = 110;
            validate_non_negative_index("susc", "N2", N2);
            validate_non_negative_index("susc", "M", M);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> susc(N2, M);
            stan::math::initialize(susc, DUMMY_VAR__);
            stan::math::fill(susc, DUMMY_VAR__);
            stan::math::assign(susc,rep_matrix(0, N2, M));
            // generated quantities statements
            {
            current_statement_begin__ = 112;
            int idx1(0);
            (void) idx1;  // dummy to suppress unused var warning
            stan::math::fill(idx1, std::numeric_limits<int>::min());
            stan::math::assign(idx1,1);
            current_statement_begin__ = 113;
            int idx2(0);
            (void) idx2;  // dummy to suppress unused var warning
            stan::math::fill(idx2, std::numeric_limits<int>::min());
            stan::math::assign(idx2,1);
            current_statement_begin__ = 114;
            for (int m = 1; m <= M; ++m) {
                {
                current_statement_begin__ = 116;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 117;
                int n1(0);
                (void) n1;  // dummy to suppress unused var warning
                stan::math::fill(n1, std::numeric_limits<int>::min());
                stan::math::assign(n1,((n0 + N0) - 1));
                current_statement_begin__ = 118;
                int n2(0);
                (void) n2;  // dummy to suppress unused var warning
                stan::math::fill(n2, std::numeric_limits<int>::min());
                stan::math::assign(n2,((n0 + get_base1(NC, m, "NC", 1)) - 1));
                current_statement_begin__ = 119;
                int len(0);
                (void) len;  // dummy to suppress unused var warning
                stan::math::fill(len, std::numeric_limits<int>::min());
                current_statement_begin__ = 120;
                local_scalar_t__ vt(DUMMY_VAR__);
                (void) vt;  // dummy to suppress unused var warning
                stan::math::initialize(vt, DUMMY_VAR__);
                stan::math::fill(vt, DUMMY_VAR__);
                current_statement_begin__ = 123;
                if (as_bool(logical_eq(link, 1))) {
                    current_statement_begin__ = 124;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::math::exp(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta")), 
                                "assigning variable Rt_unadj");
                } else if (as_bool(logical_eq(link, 2))) {
                    current_statement_begin__ = 126;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                multiply(carry, inv_logit(stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"))), 
                                "assigning variable Rt_unadj");
                } else {
                    current_statement_begin__ = 128;
                    stan::model::assign(Rt_unadj, 
                                stan::model::cons_list(stan::model::index_min_max(n0, n2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                stan::model::rvalue(eta, stan::model::cons_list(stan::model::index_min_max(idx1, ((idx1 + get_base1(NC, m, "NC", 1)) - 1)), stan::model::nil_index_list()), "eta"), 
                                "assigning variable Rt_unadj");
                }
                current_statement_begin__ = 130;
                stan::math::assign(idx1, (idx1 + get_base1(NC, m, "NC", 1)));
                current_statement_begin__ = 132;
                stan::model::assign(infections, 
                            stan::model::cons_list(stan::model::index_min_max(n0, n1), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                            rep_vector(get_base1(seeds, m, "seeds", 1), N0), 
                            "assigning variable infections");
                current_statement_begin__ = 134;
                if (as_bool(pop_adjust)) {
                    current_statement_begin__ = 135;
                    stan::model::assign(susc, 
                                stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                get_base1(pops, m, "pops", 1), 
                                "assigning variable susc");
                    current_statement_begin__ = 136;
                    if (as_bool(logical_negation(S0_fixed))) {
                        current_statement_begin__ = 136;
                        stan::model::assign(susc, 
                                    stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (stan::model::rvalue(susc, stan::model::cons_list(stan::model::index_uni(n0), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "susc") * get_base1(S0, m, "S0", 1)), 
                                    "assigning variable susc");
                    }
                }
                current_statement_begin__ = 139;
                for (int i = n0; i <= n2; ++i) {
                    {
                    current_statement_begin__ = 141;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (i - gen_len)));
                    current_statement_begin__ = 142;
                    stan::model::assign(load, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                dot_product(sub_col(infections, start, m, (i - start)), tail(gen_rev, (i - start))), 
                                "assigning variable load");
                    current_statement_begin__ = 144;
                    if (as_bool(logical_gt(i, n1))) {
                        current_statement_begin__ = 145;
                        stan::model::assign(E_infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(Rt_unadj, i, m, "Rt_unadj", 1) * get_base1(load, i, m, "load", 1)), 
                                    "assigning variable E_infections");
                        current_statement_begin__ = 146;
                        if (as_bool(latent)) {
                            current_statement_begin__ = 147;
                            if (as_bool(logical_gte(get_base1(infections_raw, idx2, "infections_raw", 1), 0))) {
                                current_statement_begin__ = 147;
                                stan::model::assign(infections, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                            get_base1(infections_raw, idx2, "infections_raw", 1), 
                                            "assigning variable infections");
                            } else {
                                {
                                current_statement_begin__ = 149;
                                local_scalar_t__ mu(DUMMY_VAR__);
                                (void) mu;  // dummy to suppress unused var warning
                                stan::math::initialize(mu, DUMMY_VAR__);
                                stan::math::fill(mu, DUMMY_VAR__);
                                stan::math::assign(mu,get_base1(E_infections, i, m, "E_infections", 1));
                                current_statement_begin__ = 150;
                                local_scalar_t__ sigma(DUMMY_VAR__);
                                (void) sigma;  // dummy to suppress unused var warning
                                stan::math::initialize(sigma, DUMMY_VAR__);
                                stan::math::fill(sigma, DUMMY_VAR__);
                                stan::math::assign(sigma,(get_base1(inf_aux, 1, "inf_aux", 1) * mu));
                                current_statement_begin__ = 151;
                                if (as_bool(fixed_vtm)) {
                                    current_statement_begin__ = 151;
                                    stan::math::assign(sigma, stan::math::sqrt(sigma));
                                }
                                current_statement_begin__ = 152;
                                stan::model::assign(infections, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                            normal_lb_rng(mu, sigma, 0.0, base_rng__, pstream__), 
                                            "assigning variable infections");
                                }
                            }
                        } else {
                            current_statement_begin__ = 155;
                            stan::model::assign(infections, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        get_base1(E_infections, i, m, "E_infections", 1), 
                                        "assigning variable infections");
                        }
                        current_statement_begin__ = 156;
                        stan::math::assign(idx2, (idx2 + 1));
                    }
                    current_statement_begin__ = 159;
                    if (as_bool(pop_adjust)) {
                        current_statement_begin__ = 160;
                        stan::model::assign(infections, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                    (get_base1(susc, i, m, "susc", 1) * (1 - stan::math::exp((-(get_base1(infections, i, m, "infections", 1)) / get_base1(pops, m, "pops", 1))))), 
                                    "assigning variable infections");
                        current_statement_begin__ = 161;
                        stan::math::assign(vt, get_base1(vacc, i, m, "vacc", 1));
                        current_statement_begin__ = 162;
                        if (as_bool(logical_negation(veps_fixed))) {
                            current_statement_begin__ = 162;
                            stan::math::assign(vt, (vt * get_base1(veps, m, "veps", 1)));
                        }
                        current_statement_begin__ = 163;
                        if (as_bool(logical_neq(i, n2))) {
                            current_statement_begin__ = 163;
                            stan::model::assign(susc, 
                                        stan::model::cons_list(stan::model::index_uni((i + 1)), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                        ((1 - vt) * (get_base1(susc, i, m, "susc", 1) - get_base1(infections, i, m, "infections", 1))), 
                                        "assigning variable susc");
                        }
                    }
                    }
                }
                }
            }
            }
            {
            current_statement_begin__ = 169;
            int i(0);
            (void) i;  // dummy to suppress unused var warning
            stan::math::fill(i, std::numeric_limits<int>::min());
            stan::math::assign(i,1);
            current_statement_begin__ = 170;
            for (int r = 1; r <= R; ++r) {
                current_statement_begin__ = 171;
                stan::model::assign(E_obs, 
                            stan::model::cons_list(stan::model::index_min_max(i, ((i + get_base1(oN, r, "oN", 1)) - 1)), stan::model::nil_index_list()), 
                            linkinv(add(segment(oeta, i, get_base1(oN, r, "oN", 1)), 1e-15), get_base1(olink, r, "olink", 1), pstream__), 
                            "assigning variable E_obs");
                current_statement_begin__ = 172;
                stan::math::assign(i, (i + get_base1(oN, r, "oN", 1)));
            }
            }
            current_statement_begin__ = 177;
            for (int i = 1; i <= N_obs; ++i) {
                {
                current_statement_begin__ = 178;
                int m(0);
                (void) m;  // dummy to suppress unused var warning
                stan::math::fill(m, std::numeric_limits<int>::min());
                stan::math::assign(m,get_base1(obs_group, i, "obs_group", 1));
                current_statement_begin__ = 179;
                int dt(0);
                (void) dt;  // dummy to suppress unused var warning
                stan::math::fill(dt, std::numeric_limits<int>::min());
                stan::math::assign(dt,get_base1(obs_date, i, "obs_date", 1));
                current_statement_begin__ = 180;
                int tp(0);
                (void) tp;  // dummy to suppress unused var warning
                stan::math::fill(tp, std::numeric_limits<int>::min());
                stan::math::assign(tp,get_base1(obs_type, i, "obs_type", 1));
                current_statement_begin__ = 181;
                int n0(0);
                (void) n0;  // dummy to suppress unused var warning
                stan::math::fill(n0, std::numeric_limits<int>::min());
                stan::math::assign(n0,get_base1(starts, m, "starts", 1));
                current_statement_begin__ = 182;
                if (as_bool(logical_eq(dt, 1))) {
                    current_statement_begin__ = 183;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * (1e-15 * get_base1(infections, 1, m, "infections", 1))), 
                                "assigning variable E_obs");
                } else {
                    {
                    current_statement_begin__ = 185;
                    int start(0);
                    (void) start;  // dummy to suppress unused var warning
                    stan::math::fill(start, std::numeric_limits<int>::min());
                    stan::math::assign(start,std::max(n0, (dt - get_base1(pvecs_len, tp, "pvecs_len", 1))));
                    current_statement_begin__ = 186;
                    stan::model::assign(E_obs, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (stan::model::rvalue(E_obs, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "E_obs") * dot_product(sub_col(infections, start, m, (dt - start)), tail(get_base1(pvecs_rev, tp, "pvecs_rev", 1), (dt - start)))), 
                                "assigning variable E_obs");
                    }
                }
                }
            }
            current_statement_begin__ = 191;
            if (as_bool(pop_adjust)) {
                current_statement_begin__ = 192;
                for (int m = 1; m <= M; ++m) {
                    current_statement_begin__ = 193;
                    stan::model::assign(Rt, 
                                stan::model::cons_list(stan::model::index_min_max(1, N2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), 
                                elt_multiply(elt_divide(stan::model::rvalue(susc, stan::model::cons_list(stan::model::index_min_max(1, N2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "susc"), get_base1(pops, m, "pops", 1)), stan::model::rvalue(Rt_unadj, stan::model::cons_list(stan::model::index_min_max(1, N2), stan::model::cons_list(stan::model::index_uni(m), stan::model::nil_index_list())), "Rt_unadj")), 
                                "assigning variable Rt");
                }
            } else {
                current_statement_begin__ = 196;
                stan::math::assign(Rt, Rt_unadj);
            }
            current_statement_begin__ = 199;
            stan::math::assign(infectiousness, divide(load, max(gen)));
            // validate, write generated quantities
            current_statement_begin__ = 103;
            size_t E_obs_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
                vars__.push_back(E_obs(j_1__));
            }
            current_statement_begin__ = 104;
            check_greater_or_equal(function__, "Rt", Rt, 0);
            size_t Rt_j_2_max__ = M;
            size_t Rt_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                    vars__.push_back(Rt(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 105;
            check_greater_or_equal(function__, "infectiousness", infectiousness, 0);
            size_t infectiousness_j_2_max__ = M;
            size_t infectiousness_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < infectiousness_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < infectiousness_j_1_max__; ++j_1__) {
                    vars__.push_back(infectiousness(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 106;
            check_greater_or_equal(function__, "Rt_unadj", Rt_unadj, 0);
            size_t Rt_unadj_j_2_max__ = M;
            size_t Rt_unadj_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                    vars__.push_back(Rt_unadj(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 107;
            check_greater_or_equal(function__, "load", load, 0);
            size_t load_j_2_max__ = M;
            size_t load_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                    vars__.push_back(load(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 108;
            check_greater_or_equal(function__, "E_infections", E_infections, 0);
            size_t E_infections_j_2_max__ = M;
            size_t E_infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                    vars__.push_back(E_infections(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 109;
            check_greater_or_equal(function__, "infections", infections, 0);
            size_t infections_j_2_max__ = M;
            size_t infections_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                    vars__.push_back(infections(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 110;
            check_greater_or_equal(function__, "susc", susc, 0);
            size_t susc_j_2_max__ = M;
            size_t susc_j_1_max__ = N2;
            for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                    vars__.push_back(susc(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_epidemia_pp_base";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t seeds_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oaux_j_1_max__ = (num_oaux + 2);
        for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oaux" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = (N + 2);
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oeta_j_1_max__ = (N_obs + 2);
        for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oeta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t infections_raw_j_1_max__ = (latent ? ((N - (M * N0)) + 2) : 2 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "infections_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t inf_aux_j_1_max__ = (latent ? 3 : 2 );
        for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inf_aux" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t S0_j_1_max__ = (S0_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "S0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t veps_j_1_max__ = (veps_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "veps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t E_obs_j_1_max__ = N_obs;
        for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "E_obs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Rt_j_2_max__ = M;
        size_t Rt_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t infectiousness_j_2_max__ = M;
        size_t infectiousness_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < infectiousness_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infectiousness_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infectiousness" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Rt_unadj_j_2_max__ = M;
        size_t Rt_unadj_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Rt_unadj" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t load_j_2_max__ = M;
        size_t load_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "load" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t E_infections_j_2_max__ = M;
        size_t E_infections_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "E_infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t infections_j_2_max__ = M;
        size_t infections_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t susc_j_2_max__ = M;
        size_t susc_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "susc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t seeds_j_1_max__ = (M + 2);
        for (size_t j_1__ = 0; j_1__ < seeds_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "seeds" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oaux_j_1_max__ = (num_oaux + 2);
        for (size_t j_1__ = 0; j_1__ < oaux_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oaux" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t eta_j_1_max__ = (N + 2);
        for (size_t j_1__ = 0; j_1__ < eta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t oeta_j_1_max__ = (N_obs + 2);
        for (size_t j_1__ = 0; j_1__ < oeta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "oeta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t infections_raw_j_1_max__ = (latent ? ((N - (M * N0)) + 2) : 2 );
        for (size_t j_1__ = 0; j_1__ < infections_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "infections_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t inf_aux_j_1_max__ = (latent ? 3 : 2 );
        for (size_t j_1__ = 0; j_1__ < inf_aux_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inf_aux" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t S0_j_1_max__ = (S0_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < S0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "S0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t veps_j_1_max__ = (veps_fixed ? 2 : (M + 2) );
        for (size_t j_1__ = 0; j_1__ < veps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "veps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t E_obs_j_1_max__ = N_obs;
        for (size_t j_1__ = 0; j_1__ < E_obs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "E_obs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Rt_j_2_max__ = M;
        size_t Rt_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < Rt_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Rt_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Rt" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t infectiousness_j_2_max__ = M;
        size_t infectiousness_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < infectiousness_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infectiousness_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infectiousness" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Rt_unadj_j_2_max__ = M;
        size_t Rt_unadj_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < Rt_unadj_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Rt_unadj_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Rt_unadj" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t load_j_2_max__ = M;
        size_t load_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < load_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < load_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "load" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t E_infections_j_2_max__ = M;
        size_t E_infections_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < E_infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < E_infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "E_infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t infections_j_2_max__ = M;
        size_t infections_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < infections_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < infections_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "infections" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t susc_j_2_max__ = M;
        size_t susc_j_1_max__ = N2;
        for (size_t j_2__ = 0; j_2__ < susc_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < susc_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "susc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_epidemia_pp_base_namespace::model_epidemia_pp_base stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
