% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsir.R
\name{tsirSpat}
\alias{tsirSpat}
\title{Function to simulate the spatially-extended seasonally-forced TSIR}
\usage{
tsirSpat(beta, alpha, B, N, p, c, inits, type = "det")
}
\arguments{
\item{beta}{the seasonal transmission coefficients}

\item{alpha}{the exponent on I}

\item{B}{a vector of Births (the length of which determines the length of the simulation)}

\item{N}{the population size}

\item{p}{the number of patches}

\item{c}{the the spatial coupling}

\item{inits}{a list containing a vector of initial S and a vector of initial I for each patch}

\item{type}{an argument "det" or "stoc" that determines whether a deterministic or stochastic simulation is done}
}
\value{
A list with time series of simulated infected and susceptible hosts
}
\description{
Function to simulate the spatially-extended seasonally-forced TSIR for a patchily
distributed host population. Coupling is assumed to be global and according to a 
commuter model so with p patches and a coupling of c, local transmission
is reduced by a fraction (1-c*p).
}
\examples{
\donttest{"see chapter 15 in book"}
}
