% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getEpiOffset}
\alias{getEpiOffset}
\title{Retrieve epistatic offset.}
\usage{
getEpiOffset(pop)
}
\arguments{
\item{pop}{A valid \code{Population} object with epistatic effects
attached}
}
\description{
Retrieve offset used for calculating epistatic component.
}
\details{
In order for the initial population to have an epistatic
component with a mean of 0 for its phenotype, an offset is added,
and it remains fixed across generations. This function retrieves
that offset.
}
\examples{
# Construct a new population with epistatic effects
pop <- Population(
  popSize = 20, map = map100snp, QTL = 20,
  broadH2 = 0.4, narrowh2 = 0, traitVar = 40,
  alleleFrequencies = runif(100, 0.05, 0.5)
)
pop <- attachEpiNet(pop)

# Find the epistatic contribution to the individuals' phenotypes
rowSums(getEpistasis(pop)) + getEpiOffset(pop)

# Compare with epistatic component from getComponents()
getComponents(pop)$Epistatic
}
\seealso{
\code{\link{getEpistasis}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
