% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getHaplo}
\alias{getHaplo}
\title{Retrieve haplotypes.}
\usage{
getHaplo(pop)
}
\arguments{
\item{pop}{a valid \code{Population} object}
}
\value{
A list is returned with two elements, corresponding to the
  two haplotype matrices.
}
\description{
Retrieve haplotypes from the population.
}
\details{
Retrieves the haplotypes from both the population which, when
added together, form the genotypes.
}
\examples{
# Construct a new population with additive effects
pop <- Population(
  popSize = 20, map = map100snp, QTL = 20,
  broadH2 = 0.4, narrowh2 = 0.4, traitVar = 40,
  alleleFrequencies = runif(100, 0.05, 0.5)
)
pop <- addEffects(pop)

# Find the additive contribution to the individuals' phenotypes
hap <- getHaplo(pop)
hap <- (hap[[1]] + hap[[2]])[, getQTL(pop)$Index]
(hap \%*\% getAddCoefs(pop))[, 1] + getAddOffset(pop)
}
\seealso{
\code{\link{getAddCoefs}}, \code{\link{getAddOffset}}, \code{\link{getPhased}}, \code{\link{getGeno}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
