% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_param.R
\name{.check_optim_conv}
\alias{.check_optim_conv}
\title{Check whether the optimisation of distribution parameters has converged to
stable value for the parameters and function output for multiple iterations}
\usage{
.check_optim_conv(optim_params_list, optim_params, tolerance)
}
\arguments{
\item{optim_params_list}{A list, where each element is the output of
\code{\link[stats:optim]{stats::optim()}}. See \code{?optim} for more details.}

\item{optim_params}{A list given by the output of \code{\link[stats:optim]{stats::optim()}}.}

\item{tolerance}{A \code{numeric} specifying within which disparity convergence
of parameter estimates and function minimisation is accepted.}
}
\value{
Boolean
}
\description{
This function is to try and prevent optimisation to a local
optimum and thus checks whether multiple optimisation routines are
consistently finding parameter values to within a set tolerance.
}
\keyword{internal}
