% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{field}
\alias{field}
\title{Field of Ordinary Differential Equation (ODE) systems.}
\usage{
field(o, x, param, differentials = FALSE, ...)
}
\arguments{
\item{o}{An object of class \code{\link{ode}} (created via \code{\link{mak}} or \code{\link{plk}}).}

\item{x}{A non-negative numeric vector holding the state of the ODE system.}

\item{param}{A non-negative numeric vector of parameter values for the ODE system (or list of these if multiple arguments are required).}

\item{differentials}{Logical indicating if the differentials with respect to the state and parameter vector ought to be returned as well.}

\item{...}{Additional arguments passed to field.}
}
\value{
If \code{differentials} is \code{FALSE} a vector (of length \code{d}) holding the evaluated value of the field.

If \code{differentials} is \code{TRUE} a list is returned with
\item{f}{A vector (length \code{d}) holding the evaluated value of the field.}
\item{f_dx}{A sparse matrix (dxd) holding the state differential of the field.}
\item{f_dparam}{A (list of) sparse matrix (dxp) holding the parameter differential of the field.}
}
\description{
Evaluates the vector field of the ODE system specified in the \code{ode} object (and optionally its differentials with respect to the state and parameter vectors).
}
\examples{
# Example: Michaelis-Menten system
A <- matrix(
c(1, 1, 0, 0,
  0, 0, 1, 0,
  0, 0, 1, 0), ncol = 4, byrow = TRUE)
B <- matrix(
c(0, 0, 1, 0,
  1, 1, 0, 0,
  1, 0, 0, 1), ncol = 4, byrow = TRUE)
k <- c(1, 2, 0.5)
x <- c(E = 1, S = 4, ES = 0, P = 0)

m <- mak(A, B)

# Vector field
field(m, x, k)

# ... with differentials
field(m, x, k, TRUE)


# Example: Power law kinetics
A <- matrix(c(1, 0, 1,
              1, 1, 0), byrow = TRUE, nrow = 2)
p <- plk(A)
x <- c(10, 4, 1)
theta <- matrix(c(0, -0.25,
                  0.75, 0,
                  0, -0.1), byrow = TRUE, nrow = 3)

# Vector field
field(p, x, theta)

# ... with differentials
field(p, x, theta, TRUE)

}
\seealso{
ode, mak, plk, rlk, ratmak
}
