% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-tagging.R
\name{update_languages}
\alias{update_languages}
\title{Updates local copies of languages}
\usage{
update_languages(tasks)
}
\arguments{
\item{tasks}{Tasks object for reporting progress and error messages, default: get_tasks()}
}
\value{
The list of tasks updated with produced messages
}
\description{
Downloading and indexing a fresh version of language models tagged for update on the Shiny app configuration tab
}
\details{
Run a one shot task to download and index a local fasttext \href{https://fasttext.cc/docs/en/crawl-vectors.html}{pretrained models}. 
A fasttext model is a collection of vectors for a language automatically produced scrolling a big corpus of text that can be used to capture the semantic of a word.

The URL to download the vectors from are set on the configuration tab of the Shiny app.

This task will also update SVM models to predict whether a word is a location that will be used in the geolocation process.

The indexing is developed in SPARK and Lucene.

A prerequisite to this function is that the \code{\link{search_loop}} must already have stored collected tweets in the search folder and that the tasks \code{\link{download_dependencies}}
and \code{\link{update_geonames}} has been run successfully.

Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # updating language tasks
   tasks <- update_languages()
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{update_geonames}}

 \code{\link{detect_loop}}

 \code{\link{get_tasks}}
}
