% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_metric}
\alias{as_metric}
\title{Convert a measured value to metric units}
\usage{
as_metric(param = NULL, meas = NULL, ..., value_only = FALSE)
}
\arguments{
\item{param}{(character) Name of measurement, e.g. param = "SCr"}

\item{meas}{(units) Measurement or vector of measurements}

\item{...}{(units) One of conversion_factors$parameter,
e.g. SCr = units::set_units(88.4, "umol/l").
Case insensitive.}

\item{value_only}{(logical) Return as value only without units}
}
\value{
(units) Converted measured value or vector of measured values,
unless \code{value_only = T}
}
\description{
Refer to \code{\link{conversion_factors}} for a full list of available conversions
}
\examples{
as_metric(param = "scr", meas = units::set_units(88.4, "umol/l"))
as_metric("scr", units::set_units(88.4, "umol/l"))

values <- units::set_units(c(60, 70, 80), "umol/l")
as_metric(SCr = values)
}
