% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5dcf.R
\name{eq5dcf}
\alias{eq5dcf}
\title{Calculate the cumulative frequency profile of an EQ-5D dataset}
\usage{
eq5dcf(data, version, ignore.invalid, ...)
}
\arguments{
\item{data}{data.frame with names MO, SC, UA, PD and AD representing
Mobility, Self-care, Usual activities, Pain/discomfort and Anxiety/depression.}

\item{version}{string of value "3L" or "5L" to indicate instrument version.}

\item{ignore.invalid}{whether to ignore invalid scores. TRUE returns NA, FALSE throws an 
error.}

\item{...}{character vector, specifying "dimensions" column names. Defaults 
are "MO", "SC", "UA", "PD" and "AD".}
}
\value{
a data.frame or list of data.frames of counts/percentages. Columns 
contain dimensions names and rows the EQ-5D score.
}
\description{
Calculate the frequency, percentage, cumulative frequency and cumulative 
percentage for each profile in an EQ-5D dataset.
}
