% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqMI.projection.R
\name{eqMI.projection}
\alias{eqMI.projection}
\title{Projection-based method for testing latent means equality}
\usage{
eqMI.projection(...)
}
\arguments{
\item{...}{The same arguments as for any lavaan model. See \code{lavaan::sem} for more information. All models fitted by Lavaan are estimated by fixing the variances of latent factors to 1.

Users must explicitly specify the name of the input elements for this function to catch. For example, specify 'data = HolzingerSwineford' instead just 'HolzingerSwineford'.}
}
\value{
A list is returned with:
\describe{
\item{\code{fit.metric}}{test of metric invariance (factor loadings). This is a prerequisite for testing equality of latent means.}
\item{\code{mvdif.test}}{t tests of the cross-group sample means for each variable.}
\item{\code{chi.stat}}{Three chi-square tests for intercepts, common factors, and unique factors. \code{chi.stat} will be needed for equivalence testing. }
\item{\code{common.test}}{t tests of common factors for each variable.}
\item{\code{specific.test}}{t tests of unique factors for each variable.}
\item{\code{latent.test}}{t tests of latent means}
\item{\code{V.index}}{validity index}
\item{\code{Pmat}}{projection matrix of intercepts into the space of common factors}
\item{\code{Qmat}}{projection matrix of intercepts into the space of unique factors}
}
}
\description{
Perform projection method for testing the equality of latent means without requiring the equality of cross-group intercepts to hold.
}
\details{
Perform projection method for testing the equality of two latent means without requiring the cross-group intercepts to be the same. A validity index is provided as the proportion of the differences in manifest variables intercepts explained by latent mean differences as a gauge of the quality of measurements.
}
\examples{
data(HolzingerSwineford)
semmodel<-'
L1 =~ V1 + V2 + V3
L2 =~ V4 + V5 + V6
L3 =~ V7 + V8
L4 =~ V9 + V10 + V11
'
run.pj <- eqMI.projection(model = semmodel, data = HolzingerSwineford,
          group = "school", meanstructure = TRUE)

}
\references{
Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426.
}
