% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egodata.R
\name{egodata}
\alias{egodata}
\alias{as.egodata}
\alias{as.egodata.data.frame}
\alias{egodata.object}
\alias{na.omit.egodata}
\alias{dim.egodata}
\alias{dimnames.egodata}
\alias{sample.egodata}
\alias{head.egodata}
\alias{sample}
\alias{sample.default}
\title{Convert to or Construct \code{\link{egodata}} Objects}
\usage{
egodata(egos, alters, egoWt = 1, ..., egoIDcol = "egoID")

as.egodata(object, ..., egoIDcol = "egoID")

\method{as.egodata}{data.frame}(object, alters, egoWt = 1, ...,
  egoIDcol = "egoID")
}
\arguments{
\item{alters}{A data frame containing at least the column named in
\code{egoIDcol}, whose values do not have to be unique, and not every ego
must be represented. Other columns contain information about the alters.}

\item{egoWt}{A vector of the same length as number of rows in \code{egos} or
\code{object}, containing the relative sampling weight of each ego.}

\item{\dots}{Additional arguments; currently unused.}

\item{egoIDcol}{Name of the column in the ego table containing the unique
ego identifier.}

\item{object, egos}{The object from which the egocentric data should be
constructed. For the \code{\link{data.frame}} methods and
\code{\link{egodata}} itself, a data frame containing at least the column
named in \code{egoIDcol}, whose values must all be unique. Other columns
contain information about the egos.}
}
\value{
An \code{\link{egodata}} object. The object is a list containing the
following elements:

\item{egos}{ A data frame with one row for each ego, containing at least the
column named in \code{egoIDcol}, and other columns containing attributes of
the egos.  }

\item{alters}{ A data frame containing at least the column named in
\code{egoIDcol}, and other columns containing attributes of the alters.  }

\item{egoWt}{A vector of the same length as the number of egos, containing
the relative sampling weight of each ego.}

\item{egoIDcol}{ Name of the column in the ego table containing the unique
ego identifier.  }
}
\description{
\code{\link{as.egodata}} is a generic function to construct
\code{\link{egodata}} objects from a variety of sources.
\code{\link{egodata}} function is the standard constructor, taking two data
frames. For other methods for this class, see the Miscellaneous Methods
section.
}
\section{Miscellaneous Methods}{
 The following \dQuote{standard} methods have
also been implemented for \code{\link{egodata}}: \describe{
\item{"dim.egodata"}{A vector with three elements containing the
\dQuote{dimensions} of the \code{\link{egodata}} object: number of egos,
number of columns in the \code{egos} table, and number of columns in the
\code{alters} table, inclsive of the ego identifier column. As a corollary,
\code{\link{nrow}} returns the number of egos in the dataset.  }

\item{"dimnames.egodata"}{A list with three elements containing
the \dQuote{dimension names} of the \code{\link{egodata}} object: ego IDs,
column names of the \code{egos} table, and column names of the \code{alters}
table, inclsive of the ego identifier column.  }

\item{"sample.egodata"}{ As \code{\link{sample}}, but takes and
returns a simulated \code{\link{egodata}} dataset by resampling egos,
adjusting ego weights as necessary, if weighted sampling was used.  }

\item{"head.egodata"}{ As \code{\link{head}}, but returns the
first \code{n} rows of egos, alters, and weights.  }

\item{"na.omit.egodata"}{ As \code{\link{na.omit.data.frame}},
but takes and returns an \code{\link{egodata}} dataset, with egos with
\code{NA} in their rows or in their alters' rows. An optional argument
\code{relevant}, defaulting to all columns, can be used to select (by index
or name) based on which columns an ego may be dropped. (I.e., \code{NA}s in
those not \dQuote{relevant} are ignored.)  } }
}

\seealso{
\code{\link{ergm.ego}} for examples,
\code{\link{as.network.egodata}}, \code{\link{as.egodata.network}},
\code{\link{subset.egodata}}, \code{\link{[.egodata}}
}
\author{
Pavel N. Krivitsky
}
\keyword{manip}
\keyword{methods}
