% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mple_sign.R
\name{mple_sign}
\alias{mple_sign}
\title{Fit an ERGM with MPLE using a logistic regression model}
\usage{
mple_sign(formula, control = control.ergm(), seed = NULL, ...)
}
\arguments{
\item{formula}{An ERGM formula with the network on the left-hand side.}

\item{control}{A list of control parameters for \code{\link[ergm]{ergmMPLE}}.
By default, the covariance method is set to "Godambe".}

\item{seed}{Optional integer to set the random seed for reproducibility when
simulating networks for Godambe covariance estimation.}

\item{...}{Additional arguments passed to \code{\link[ergm]{ergmMPLE}}.}
}
\value{
An object of class \code{\link[ergm]{ergm}}.
}
\description{
Returns a fitted logistic regression model used to calculate the maximum
pseudolikelihood estimate (MPLE) of an exponential random graph model (ERGM).
}
\details{
The MPLE is calculated by first computing matrices of positive and negative
change statistics. These are then used to estimate the MPLE via logistic
regression. Optionally, the covariance can be estimated using the Godambe
method.
}
\examples{
data(tribes)
mple_sign(tribes ~ Pos(~edges) + Neg(~edges))

}
\seealso{
\code{\link[ergm]{ergmMPLE}}, \code{\link[ergm]{ergm}}, \code{\link[stats]{glm}}
}
