% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.ergm.R
\name{simulate.ergm}
\alias{simulate.ergm}
\alias{simulate.formula_lhs_network}
\alias{simulate.formula.ergm}
\alias{simulate_formula}
\alias{.simulate_formula.network}
\alias{simulate_formula.network}
\alias{simulate.formula_lhs_pending_update_network}
\alias{simulate_formula.pending_update_network}
\alias{simulate.ergm_model}
\title{Draw from the distribution of an Exponential Family Random Graph Model}
\usage{
\method{simulate}{formula_lhs_network}(object, nsim = 1, seed = NULL, ...)

simulate_formula(object, ..., basis = eval_lhs.formula(object))

\method{simulate_formula}{network}(
  object,
  nsim = 1,
  seed = NULL,
  coef,
  response = NULL,
  reference = ~Bernoulli,
  constraints = ~.,
  monitor = NULL,
  statsonly = FALSE,
  esteq = FALSE,
  output = c("network", "stats", "edgelist", "pending_update_network"),
  simplify = TRUE,
  sequential = TRUE,
  control = control.simulate.formula(),
  verbose = FALSE,
  ...,
  basis = eval_lhs.formula(object),
  do.sim = TRUE
)

\method{simulate}{formula_lhs_pending_update_network}(object, nsim = 1, seed = NULL, ...)

\method{simulate_formula}{pending_update_network}(
  object,
  nsim = 1,
  seed = NULL,
  coef,
  response = NULL,
  reference = ~Bernoulli,
  constraints = ~.,
  monitor = NULL,
  statsonly = FALSE,
  esteq = FALSE,
  output = c("network", "stats", "edgelist", "pending_update_network"),
  simplify = TRUE,
  sequential = TRUE,
  control = control.simulate.formula(),
  verbose = FALSE,
  ...,
  basis = eval_lhs.formula(object),
  do.sim = TRUE
)

\method{simulate}{ergm_model}(
  object,
  nsim = 1,
  seed = NULL,
  coef,
  response = NULL,
  reference = ~Bernoulli,
  constraints = ~.,
  monitor = NULL,
  basis = NULL,
  esteq = FALSE,
  output = c("network", "stats", "edgelist", "pending_update_network"),
  simplify = TRUE,
  sequential = TRUE,
  control = control.simulate.formula(),
  verbose = FALSE,
  ...
)

\method{simulate}{ergm}(
  object,
  nsim = 1,
  seed = NULL,
  coef = object$coef,
  response = object$response,
  reference = object$reference,
  constraints = object$constraints,
  monitor = NULL,
  basis = object$newnetwork,
  statsonly = FALSE,
  esteq = FALSE,
  output = c("network", "stats", "edgelist", "pending_update_network"),
  simplify = TRUE,
  sequential = TRUE,
  control = control.simulate.ergm(),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{Either a \code{\link{formula}} or an
\code{\link{ergm}} object.  The \code{\link{formula}} should be of the form
\code{y ~ <model terms>}, where \code{y} is a network object or a matrix
that can be coerced to a \code{\link[network]{network}} object.  For the
details on the possible \code{<model terms>}, see \code{\link{ergm-terms}}.
To create a \code{\link[network]{network}} object in , use the
\code{network()} function, then add nodal attributes to it using the
\code{\%v\%} operator if necessary.}

\item{nsim}{Number of networks to be randomly drawn from the given
distribution on the set of all networks, returned by the Metropolis-Hastings
algorithm.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{\dots}{Further arguments passed to or used by methods.}

\item{basis}{a value (usually a \code{\link{network}}) to override the LHS of the formula.}

\item{coef}{Vector of parameter values for the model from which the sample
is to be drawn.  If \code{object} is of class \code{ergm}, the default value
is the vector of estimated coefficients.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{reference}{A one-sided formula specifying
the reference measure (\eqn{h(y)}) to be used.
See help for \link[=ergm-references]{ERGM reference measures} implemented in the
\strong{\link[=ergm-package]{ergm}} package.}

\item{constraints}{A one-sided formula specifying one or more
constraints on the support of the distribution of the networks
being simulated. See the documentation for a similar argument for
\code{\link{ergm}} and see \link[=ergm-constraints]{list of implemented constraints} for more information. For
\code{simulate.formula}, defaults to no constraints. For
\code{simulate.ergm}, defaults to using the same constraints as
those with which \code{object} was fitted.}

\item{monitor}{A one-sided formula specifying one or more terms
whose value is to be monitored. These terms are appeneded to the
model, along with a coefficient of 0, so their statistics are
returned. An \code{\link{ergm_model}} objectcan be passed as well.}

\item{statsonly}{Logical: If TRUE, return only the network statistics, not
the network(s) themselves. Deprecated in favor of \verb{output=}.}

\item{esteq}{Logical: If TRUE, compute the sample estimating equations of an
ERGM: if the model is non-curved, all non-offset statistics are returned
either way, but if the model is curved, the score estimating function values
(3.1) by Hunter and Handcock (2006) are returned instead.}

\item{output}{Normally character, one of \code{"network"} (default),
\code{"stats"}, \code{"edgelist"}, or \code{"pending_update_network"} to
determine the output format. Partial matching is
performed.

Alternatively, a function with prototype
\verb{function(pending_update_network, chain, iter, ...)} that is
called for each returned network, and its return value, rather
than the network itself, is stored. This can be used to, for
example, store the simulated networks to disk without storing
them in memory or compute network statistics not implemented
using the ERGM API, without having to store the networks
themselves.}

\item{simplify}{Logical: If \code{TRUE} the output is "simplified":
sampled networks are returned in a single list, statistics from
multiple parallel chains are stacked, etc.. This makes it
consistent with behavior prior to \code{ergm} 3.10.}

\item{sequential}{Logical: If FALSE, each of the \code{nsim} simulated
Markov chains begins at the initial network.  If TRUE, the end of one
simulation is used as the start of the next.  Irrelevant when \code{nsim=1}.}

\item{control}{A list of control parameters for algorithm tuning.
Constructed using \code{\link{control.simulate.ergm}} or
\code{\link{control.simulate.formula}}, which have different defaults.}

\item{verbose}{Logical: If TRUE, extra information is printed as the Markov
chain progresses.}

\item{do.sim}{Logical: If \code{FALSE}, do not proceed to the simulation
but rather return a list of arguments that would have been passed
to \code{\link[=simulate.ergm_model]{simulate.ergm_model()}}. This can be useful if, for example,
one wants to run several simulations with varying coefficients
and did not want to reinitialize the model and the proposal ever
time.}
}
\value{
If \code{output=="stats"} an \code{\link{mcmc}} object containing the
simulated network statistics. If \code{control$parallel>0}, an
\code{\link{mcmc.list}} object. If \code{simplify=TRUE} (the default), these
would then be "stacked" and converted to a standard \code{\link{matrix}}. A
logical vector indicating whether or not the term had come from
the \verb{monitor=} formula is stored in \code{\link[=attr]{attr()}}-style attribute
\code{"monitored"}.

Otherwise, a representation of the simulated network is returned,
in the form specified by \code{output}. In addition to a network
representation or a list thereof, they have the following
\code{\link{attr}}-style attributes: \describe{

\item{\code{formula}}{The \code{\link{formula}} used to generate the
sample.}

\item{\code{stats}}{An \code{\link{mcmc}} or \code{\link{mcmc.list}} object as above.}

\item{\code{control}}{Control parameters used to generate the sample.}

\item{\code{constraints}}{Constraints used to generate the sample.}

\item{\code{reference}}{The reference measure for the sample.}

\item{\code{monitor}}{The monitoring formula.}

\item{\code{response}}{The edge attribute used as a response.}

}

The following are the permitted network formats: \describe{

\item{\code{"network"}}{If \code{nsim==1}, an object of class
\code{network}.  If \code{nsim>1}, it returns an object of class
\code{\link{network.list}} (a list of networks) with the
above-listed additional attributes.}

\item{\code{"edgelist"}}{An \code{\link{edgelist}} representation of the network,
or a list thereof, depending on \code{nsim}.}

\item{\code{"pending_update_network"}}{A semi-internal representation of
a network consisting of a \code{\link{network}} object emptied of edges, with
an attached edgelist matrix, or a list thereof, depending on
\code{nsim}.}

}

If \code{simplify==FALSE}, the networks are returned as a nested list,
with outer list being the parallel chain (including 1 for no
parallelism) and inner list being the samples within that chains
(including 1, if one network per chain). If \code{TRUE}, they are
concatenated, and if a total of one network had been simulated, the
network itself will be returned.
}
\description{
\code{\link[stats]{simulate}} is used to draw from exponential
family random network models.  See \code{\link{ergm}} for more
information on these models.

The method for \code{\link{ergm}} objects inherits the model,
the coefficients, the response attribute, the reference, the
constraints, and most simulation parameters from the model fit,
unless overridden by passing them explicitly. Unless overridden,
the simulation is initialized with a random draw from the fitted
model, saved by \code{\link[=ergm]{ergm()}}.
}
\details{
A sample of networks is randomly drawn from the specified model.  The model
is specified by the first argument of the function.  If the first argument
is a \code{\link{formula}} then this defines the model.  If the first
argument is the output of a call to \code{\link{ergm}} then the model used
for that call is the one fit -- and unless \code{coef} is specified, the
sample is from the MLE of the parameters.  If neither of those are given as
the first argument then a Bernoulli network is generated with the
probability of ties defined by \code{prob} or \code{coef}.

Note that the first network is sampled after \code{burnin} steps,
and any subsequent networks are sampled each \code{interval} steps
after the first.

More information can be found by looking at the documentation of
\code{\link{ergm}}.
}
\note{
\code{\link[=simulate.ergm_model]{simulate.ergm_model()}} is a lower-level interface, providing
a \code{\link[=simulate]{simulate()}} method for \code{\link{ergm_model}} class. The \code{basis}
argument is required; \code{monitor}, if passed, must be an
\code{\link{ergm_model}} as well; and \code{constraints} can be an
\code{\link{ergm_proposal}} object instead.
}
\examples{
\dontshow{
options(ergm.eval.loglik=FALSE)
}
#
# Let's draw from a Bernoulli model with 16 nodes
# and density 0.5 (i.e., coef = c(0,0))
#
g.sim <- simulate(network(16) ~ edges + mutual, coef=c(0, 0))
#
# What are the statistics like?
#
summary(g.sim ~ edges + mutual)
#
# Now simulate a network with higher mutuality
#
g.sim <- simulate(network(16) ~ edges + mutual, coef=c(0,2))
#
# How do the statistics look?
#
summary(g.sim ~ edges + mutual)
#
# Let's draw from a Bernoulli model with 16 nodes
# and tie probability 0.1
#
g.use <- network(16,density=0.1,directed=FALSE)
#
# Starting from this network let's draw 3 realizations
# of a edges and 2-star network
#
g.sim <- simulate(~edges+kstar(2), nsim=3, coef=c(-1.8,0.03),
               basis=g.use, control=control.simulate(
                 MCMC.burnin=1000,
                 MCMC.interval=100))
g.sim
summary(g.sim)
#
# attach the Florentine Marriage data
#
data(florentine)
#
# fit an edges and 2-star model using the ergm function
#
gest <- ergm(flomarriage ~ edges + kstar(2))
summary(gest)
#
# Draw from the fitted model (statistics only), and observe the number
# of triangles as well.
#
g.sim <- simulate(gest, nsim=10, 
            monitor=~triangles, output="stats",
            control=control.simulate.ergm(MCMC.burnin=1000, MCMC.interval=100))
g.sim

# Custom output: store the edgecount (computed in R), iteration index, and chain index.
output.f <- function(x, iter, chain, ...){
  list(nedges = network.edgecount(as.network(x)),
       chain = chain, iter = iter)
}
g.sim <- simulate(gest, nsim=3,
            output=output.f, simplify=FALSE,
            control=control.simulate.ergm(MCMC.burnin=1000, MCMC.interval=100))
unclass(g.sim)
}
\seealso{
\code{\link{ergm}}, \code{\link[network]{network}}
}
\keyword{models}
