% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.network.R
\name{summary_formula}
\alias{summary_formula}
\alias{summary_formula.ergm}
\alias{summary_formula.network.list}
\alias{summary_formula.network}
\alias{summary_formula.pending_update_network}
\alias{summary_formula.matrix}
\alias{summary_formula.default}
\title{Dispatching a summary function based on the class of the LHS of a
formula.}
\usage{
summary_formula(object, ..., basis = NULL)

\method{summary_formula}{ergm}(object, ..., basis = NULL)

\method{summary_formula}{network.list}(object, response = NULL, ..., basis = NULL)

\method{summary_formula}{network}(object, response = NULL, ..., basis = NULL)

\method{summary_formula}{pending_update_network}(object, response = NULL, ..., basis = NULL)

\method{summary_formula}{matrix}(object, response = NULL, ..., basis = NULL)

\method{summary_formula}{default}(object, response = NULL, ..., basis = NULL)
}
\arguments{
\item{object}{A two-sided formula.}

\item{\dots}{further arguments passed to or used by methods.}

\item{basis}{Optional object of the same class as the LHS of the formula, substituted in place of the LHS.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}
}
\value{
A vector of statistics measured on the network.
}
\description{
The generic \code{\link[=summary_formula]{summary_formula()}} (note the underscore) expects a
formula argument and will attempt to identify the class of the LHS
of the formula and dispatch to the appropriate \code{summary_formula}
method.
}
\section{Methods (by class)}{
\itemize{
\item \code{ergm}: an \code{\link{ergm}} fit method, extracting its model from the fit.

\item \code{network.list}: a method for a \code{\link{network.list}} on the LHS of the formula.

\item \code{network}: a method for a \code{\link{network}} on the LHS of the formula.

\item \code{pending_update_network}: a method for the semi-internal \code{\link{pending_update_network}} on the LHS of the formula.

\item \code{matrix}: a method for a \code{\link{matrix}} on the LHS of the formula.

\item \code{default}: a fallback method.
}}

\examples{

#
# Lets look at the Florentine marriage data
#
data(florentine)
#
# test the summary_formula function
#
summary(flomarriage ~ edges + kstar(2))
m <- as.matrix(flomarriage)
summary(m ~ edges)  # twice as large as it should be
summary(m ~ edges, directed=FALSE) # Now it's correct

}
\seealso{
\code{\link[=ergm]{ergm()}}, \code{\link[=network]{network()}}, \link{ergm-terms}

\code{\link[=summary.ergm_model]{summary.ergm_model()}}
}
\keyword{internal}
\keyword{models}
