% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_model.R, R/is.curved.R,
%   R/is.dyad.independent.R, R/nparam.R, R/param_names.R
\name{ergm_model}
\alias{ergm_model}
\alias{c.ergm_model}
\alias{as.ergm_model}
\alias{as.ergm_model.ergm_model}
\alias{as.ergm_model.formula}
\alias{is.curved.ergm_model}
\alias{is.dyad.independent.ergm_model}
\alias{nparam.ergm_model}
\alias{param_names.ergm_model}
\title{Internal representation of an \code{ergm} network model}
\usage{
ergm_model(
  formula,
  nw = NULL,
  silent = FALSE,
  ...,
  term.options = list(),
  extra.aux = list(),
  env = globalenv(),
  offset.decorate = TRUE
)

\method{c}{ergm_model}(...)

as.ergm_model(x, ...)

\method{as.ergm_model}{ergm_model}(x, ...)

\method{as.ergm_model}{formula}(x, ...)

\method{is.curved}{ergm_model}(object, ...)

\method{is.dyad.independent}{ergm_model}(object, ...)

\method{nparam}{ergm_model}(object, canonical = FALSE, offset = NA, byterm = FALSE, ...)

\method{param_names}{ergm_model}(object, canonical = FALSE, offset = NA, ...)
}
\arguments{
\item{formula}{An \code{\link[=ergm]{ergm()}}
formula of the form \code{network ~ model.term(s)} or \code{~
model.term(s)}.}

\item{nw}{The network of interest; if passed, the LHS of \code{formula} is ignored. This is the recommended usage.}

\item{silent}{logical, whether to print the warning messages from the
initialization of each model term.}

\item{\dots}{additional parameters for model formulation}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{extra.aux}{a list of auxiliary request formulas required elsewhere; if named, the resulting \code{slots.extra.aux} will also be named.}

\item{env}{a throwaway argument needed to prevent conflicts with some usages of \code{ergm_model}. The initialization environment is \emph{always} taken from the \code{formula}.}

\item{offset.decorate}{logical; whether offset coefficient and parameter names should be enclosed in \code{"offset()"}.}

\item{x}{object to be converted to an \code{ergm_model}.}

\item{object}{An \code{ergm_model} object.}

\item{canonical}{Whether the canonical (eta) parameters or the curved (theta) parameters are used.}

\item{offset}{If \code{NA} (the default), all model terms are counted;
if \code{TRUE}, only offset terms are counted; and if
\code{FALSE}, offset terms are skipped.}

\item{byterm}{Whether to return a vector of the numbers of
coefficients for each term.}
}
\value{
\code{ergm_model} returns an  \code{ergm_model} object as a list
containing:
\item{coef.names}{a vector of coefficient names}
\item{terms}{a list of terms and 'term components' initialized by the
appropriate \code{InitErgmTerm.X} function.}
\item{etamap}{the theta -> eta mapping as a list returned from
<ergm.etamap>}
}
\description{
These methods are generally not called directly by users, but may
be employed by other depending packages.
\code{ergm_model} constructs it from a formula. Each term is
initialized via the \code{InitErgmTerm} functions to create a
\code{ergm_model} object.
}
\section{Methods (by generic)}{
\itemize{
\item \code{c}: A method for concatenating terms of two or more initialized models.

\item \code{is.curved}: Tests whether the model is curved.

\item \code{is.dyad.independent}: Tests whether the model is dyad-independent.

\item \code{nparam}: Number of parameters of the model.

\item \code{param_names}: Parameter names of the model.
}}

\note{
This API is not to be considered fixed and may change between versions. However, an effort will be made to ensure that the methods of this class remain stable.
}
\seealso{
\code{\link[=summary.ergm_model]{summary.ergm_model()}}
}
\keyword{internal}
