% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_to_daily.R
\name{attach_t_agg}
\alias{attach_t_agg}
\title{Attach time index (number of days) column. Exclude first day since we don't necessarily know over which period of time that data was aggregated}
\usage{
attach_t_agg(cl.input, prm.daily = NULL, silent = FALSE)
}
\arguments{
\item{cl.input}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of report
\item \code{value}: count of reported cases
}}

\item{prm.daily}{List. Parameters for daily report inference via MCMC. Elements include:
\itemize{
\item \code{burn}: Numeric. Length of burn-in period (number of days).
\item \code{iter}: Numeric. Number of iterations after burn-in period (number of days).
\item \code{chains}: Numeric. Number of chains to simulate.
\item \code{first.agg.period}: length of aggregation period for first aggregated observation (number of days); if NULL, assume same aggregation period as observed for second observation (gap between first and second observations)
\item \code{prior_R0_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_R0_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for R0.
\item \code{prior_alpha_shape}: Shape of the (hyper-)parameter for the prior Gamma distribution for alpha.
\item \code{prior_alpha_rate}: Rate of the (hyper-)parameter for the prior Gamma distribution for alpha.
}}

\item{silent}{Logical. Flag to suppress all output messages, warnings, and progress bars.}
}
\value{
Data frame
}
\description{
Attach time index (number of days) column. Exclude first day since we don't necessarily know over which period of time that data was aggregated
}
\keyword{internal}
