% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Difference.R
\name{dif.wave}
\alias{dif.wave}
\title{Calculate a difference waveform from two data frames}
\usage{
dif.wave(x, z, keep = "y")
}
\arguments{
\item{x}{A data frame in the format returned from \code{\link{load.data}}. This value serves
as the minuend (i.e., value to be subtracted from).}

\item{z}{A data frame in the format returned from \code{load.data}. This value serves
as the subtrahend (i.e., value subtracted).}

\item{keep}{Valid inputs can be "y" or "n." When \code{keep} = "y", the data frame returned
  from the function will consist of both the difference data frame and the data
  frame provided for x (i.e., the minuend).  If \code{keep} = "n" then only the
  resulting difference data frame will be returned.}
}
\value{
One of two possible data frames, depending on the value of \code{keep}:
\enumerate{
  \item \code{keep} = "y": the difference (i.e., x - z) data frame
    and the minuend data frame (i.e., x)
  \item \code{keep} = "n": just the difference data frame
}
}
\description{
\code{dif.wave} calculates a difference waveform from two data frames in the format
  returned from \code{load.data}
}
\details{
The data frames must either: \enumerate{
   \item have been imported using \code{load.data}
   - OR -
   \item for subset data, the "Stimulus" column must be "refactored." See the example
   below for one way to "reset" the factors in the "Stimulus" column.  Note this procedure
   is only necessary for subset data, and not data frames that were independently imported.
}
}
\examples{
# Calculate a difference wave
 Negative = ERPdata[1:6765, ]
 Neutral = ERPdata[6766:13530, ]
 refactor.neg <- factor(Negative$Stimulus)
 refactor.neut <- factor(Neutral$Stimulus)
 Negative$Stimulus <- refactor.neg
 Neutral$Stimulus <- refactor.neut
 difference <- dif.wave(Negative, Neutral, keep = "y")
 grandaverage(difference, "V78") # plot the grand average difference wave
}
\author{
Travis Moore
}

