% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{best_distribution}
\alias{best_distribution}
\title{Distribution with Best Error Intervals}
\usage{
best_distribution(phi, errors, dists = c("n", "nm", "l", "lm", "w", "b"), ...)
}
\arguments{
\item{phi}{residual values used to compute the error interval.}

\item{errors}{set of real errors corresponding to the predictions of a particular
model.}

\item{dists}{character vector with the distribution assumptions to test. See also
'Details'.}

\item{...}{additional arguments to be passed to functions \code{error_interval}
and \code{acc_intervals}.}
}
\value{
Returns an object of class \code{c("df_intervals", "data.frame")} with
information of the distribution assumption with lower accuracy error.
}
\description{
\code{best_distribution} computes the distribution assumption that
gives error intervals with the lower accuracy error for a given set of residuals.
}
\details{
Allowed distribution assumptions are:
\itemize{
 \item{"n": }{Zero-mu Gaussian}
 \item{"nm": }{General Gaussian}
 \item{"l": }{Zero-mu Laplace}
 \item{"lm": }{General Laplace}
 \item{"b": }{Beta}
 \item{"w": }{Weibull}
}
}
\examples{
best_distribution(rnorm(10000),rnorm(10000),dists=c("n","b"))
best_distribution(rnorm(10000),rnorm(10000))
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}
\seealso{
\link{df_intervals} \link{error_interval} \link{acc_intervals}
}

