% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demand_n_at_dose.R
\name{demand_n_at_dose}
\alias{demand_n_at_dose}
\title{Demand there are n patients at a dose before condisdering stopping.}
\usage{
demand_n_at_dose(parent_selector_factory, n, dose)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{n}{Continue at least until there are n at a dose.}

\item{dose}{\code{'any'} to continue until there are n at any dose;
\code{'recommended'} to continue until there are n at the recommended dose;
or an integer to continue until there are n at a particular dose-level.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method continues a dose-finding trial until there are n patients at a
dose. Once that condition is met, it delegates stopping responsibility to its
parent dose selector, whatever that might be. This class is greedy in that it
meets its own needs before asking any other selectors in a chain what they
want. Thus, different behaviours may be achieved by nesting dose selectors
in different orders. See examples.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25

# This model will demand 9 at any dose before it countenances stopping.
model1 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  demand_n_at_dose(n = 9, dose = 'any')

# This model will recommend continuing:
model1 \%>\% fit('1NNT 1NNN 2TNN 2NNN') \%>\% continue()
# It tells you to continue because there is no selector considering when
# you should stop - dfcrm implements no stopping rule by default.

# In contrast, we can add a stopping selector to discern the behaviour of
# demand_n_at_dose. We will demand 9 are seen at the recommended dose before
# stopping is permitted in model3:
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_at_n(n = 12)
model3 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_at_n(n = 12) \%>\%
  demand_n_at_dose(n = 9, dose = 'recommended')

# This model advocates stopping because 12 patients are seen in total:
model2 \%>\% fit('1NNN 1NNN 2TNN 2NNN') \%>\% continue()
# But this model advocates continuing because 9 patients have not been seen
# at any dose yet:
model3 \%>\% fit('1NNN 1NNN 2TNN 2NNN') \%>\% continue()
# This shows how demand_n_at_dose overrides stopping behaviours that come
# before it in the daisychain.

# Once 9 are seen at the recommended dose, the decision to stop is made:
fit <- model3 \%>\% fit('1NNN 1NNN 2TNN 2NNN 2TTN')
fit \%>\% continue()
fit \%>\% recommended_dose()
}
