% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_amplitude.R
\name{spatial_amplitude}
\alias{spatial_amplitude}
\title{Locate the source of a seismic event by modelling amplutide attenuation}
\usage{
spatial_amplitude(data, coupling, d_map, aoi, v, q, f, a_0, normalise = TRUE)
}
\arguments{
\item{data}{\code{Numeric} matrix or \code{eseis} object, seismic signals 
to work with. Since the function will calculate the maxima of the data it 
is usually the envolopes of the data that should be used here.}

\item{coupling}{\code{Numeric} vector, coupling efficiency factors for each
seismic station. The best coupled station (or the one with the highest 
amplification) must receive \code{1}, the others must be scaled relatively 
to this one.}

\item{d_map}{\code{List} object, distance maps for each station (i.e., 
\code{SpatialGridDataFrame} objects). Output of \code{distance_map}.}

\item{aoi}{\code{SpatialGridDataFrame} or \code{raster} object that 
defines which pixels are used to locate the source. If omitted, the entire 
distance map extent is used. \code{aoi} and \code{d_map} objects must have
the same extents, projections and pixel sizes. The \code{aoi} map must 
be of logical values.}

\item{v}{\code{Numeric} value, mean velocity of seismic waves (m/s).}

\item{q}{\code{Numeric} value, quality factor of the ground.}

\item{f}{\code{Numeric} value, frequency for which to model the 
attenuation.}

\item{a_0}{\code{Logical} value, start parameter of the source amplitude,
if not provided, a best guess is made as 100 times the maximum amplitude 
value of the data set.}

\item{normalise}{\code{Logical} value, option to normalise sum of 
residuals between 0 and 1. Default is \code{TRUE}.}
}
\value{
A raster object with the sums of squared model residuals for each 
grid cell.
}
\description{
The function fits a model of signal amplitude attenuation for all grid 
cells of the distance data sets and returns the residual sum as measure 
of the most likely source location of an event.
}
\examples{

\dontrun{

L <- spatial_amplitude(data = s_f, 
coupling = c(1, 1, 1, 1),
d_map = D_50$maps, 
v = 900, 
q = 100, 
f = 7.5)

}

}
\author{
Michael Dietze
}
