% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_fill.R
\name{signal_fill}
\alias{signal_fill}
\title{Fill NA-gaps of a signal}
\usage{
signal_fill(data)
}
\arguments{
\item{data}{\code{eseis} object, numeric vector or list of objects, 
data set to be processed.}
}
\value{
\code{eseis} object, numeric vector or list of objects, 
interpolated data set(s).
}
\description{
This function performs linear interpolation of NA values.
}
\details{
Note that the procedure will contaminate the signal by artefacts as 
increasingly larger data gaps are filled with interpolated values.
}
\examples{

## create synthetic data set and add NA-gaps
x <- eseis::signal_detrend(data = runif(1000))
x_gap <- x
x_gap[100:102] <- NA
x_gap[500:530] <- NA

## fill gaps
y <- signal_fill(data = x_gap)

## filter both data sets
x <- signal_filter(data = x, f = c(1, 3), dt = 1/200)
y <- signal_filter(data = y, f = c(1, 3), dt = 1/200)

## plot both data sets
plot(y, type = "l", col = "grey", lwd = 3)
lines(x, col = "red")

}
\author{
Michael Dietze
}
\keyword{eseis}
