% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_distance.R
\name{spatial_distance}
\alias{spatial_distance}
\title{Calculate topography-corrected distances for seismic waves.}
\usage{
spatial_distance(
  stations,
  dem,
  topography = TRUE,
  maps = TRUE,
  matrix = TRUE,
  aoi,
  verbose = FALSE
)
}
\arguments{
\item{stations}{\code{Numeric} matrix of length two, x- and y-coordinates 
of the seismic stations to be processed (column-wise orgnaised).The 
coordinates must be in metric units, such as the UTM system and 
match with the reference system of the \code{dem}.}

\item{dem}{\code{SpatRaster} object, the digital elevation model (DEM) to 
be processed. The DEM must be in metric units, such as the UTM system and 
match with the reference system of the coordinates of \code{stations}. 
See \code{terra} for supported types and how to read these to R.}

\item{topography}{\code{Logical} scalar, option to enable topography
correction, default is \code{TRUE}.}

\item{maps}{\code{Logical} scalar, option to enable/disable calculation
of distance maps. Default is \code{TRUE}.}

\item{matrix}{\code{Logical} scalar, option to enable/disable calculation
of interstation distances. Default is \code{TRUE}.}

\item{aoi}{\code{Numeric} vector of length four, bounding coordinates of 
the area of interest to process, in the form \code{c(x0, x1, y0, y1)}.}

\item{verbose}{\code{Logical} value, option to show extended function 
information as the function is running. Default is \code{FALSE}.}
}
\value{
\code{List} object with distance maps (list of 
\code{SpatRaster} objects from \code{terra} package) and station distance 
matrix (\code{data.frame}).
}
\description{
The function calculates topography-corrected distances either between 
seismic stations or from seismic stations to pixels of an input raster.
}
\details{
Topography correction is necessary because seismic waves can only travel 
on the direct path as long as they are within solid matter. When the 
direct path is through air, the wave can only travel along the surface
of the landscape. The function accounts for this effect and returns the
corrected travel distance data set.
}
\examples{

\dontrun{

data("volcano")
dem <- terra::rast(volcano)
dem <- dem * 10
terra::ext(dem) <- terra::ext(dem) * 10
terra::ext(dem) <-terra::ext(dem) + c(510, 510, 510, 510)

## define example stations
stations <- cbind(c(200, 700), c(220, 700))

## plot example data
terra::plot(dem)
points(stations[,1], stations[,2])

## calculate distance matrices and stations distances
D <- spatial_distance(stations = stations, 
                      dem = dem)

terra::plot(D$maps[[1]])

## show station distance matrix
print(D$matrix)

## calculate with AOI and in verbose mode
D <- spatial_distance(stations = stations, 
                      dem = dem, 
                      verbose = TRUE,
                      aoi = c(0, 200, 0, 200))

## plot distance map for station 2
terra::plot(D$maps[[1]])

} 
                                          
}
\author{
Michael Dietze
}
\keyword{eseis}
