% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_aggregate.R
\name{time_aggregate}
\alias{time_aggregate}
\title{Aggregate a time series}
\usage{
time_aggregate(data, n = 2)
}
\arguments{
\item{data}{\code{POSIXct} vector, time to be processed.}

\item{n}{\code{Numeric} value, number of samples to be aggregated to one
new data value. Must be an integer value greater than 1. Default is 
\code{2}.}
}
\value{
\code{POSIXct} vector, aggregated data.
}
\description{
The time series \code{x} is aggregated by an integer factor \code{n}.
}
\examples{

## load example data set
data(rockfall)

## aggregate time series
rockfall_t_agg <- time_aggregate(data = rockfall_t, 
                          n = 2)

## compare results
range(rockfall_t)
diff(rockfall_t)

range(rockfall_t_agg)
diff(rockfall_t_agg)

}
\author{
Michael Dietze
}
\keyword{eseis}
