% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_template.R
\name{use_template}
\alias{use_template}
\title{Import esmtools RMarkdown Templates}
\usage{
use_template(template_name, output_dir, overwrite = FALSE)
}
\arguments{
\item{template_name}{A character string specifying the name of the template to be copied.
Valid options are "preprocess_esm", "advanced_preprocess_esm", and "data_characteristics_report".}

\item{output_dir}{A mandatory character string specifying the directory where the template should be copied.}

\item{overwrite}{Logical indicating whether to overwrite existing files with the same name in the output directory.
Default is \code{FALSE}.}
}
\value{
Invisible \code{NULL}
}
\description{
The \code{use_template()} function allows you to copy esmtools RMarkdown templates
from the package to your working directory for further customization and usage.
}
\examples{
if (interactive()) {
  # Copy and paste the "preprocess_esm" template to the current working directory
  use_template("preprocess_esm")

  # Copy and paste the "advanced_preprocess_esm" template to a specific directory
  use_template("advanced_preprocess_esm", output_dir = "/path/to/templates")

  # Copy and paste the "data_characteristics_report" template to the current working directory
  # and overwrite existing file (if any).
  use_template("data_characteristics_report", overwrite = TRUE)
}
}
