% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_from_dcm.R
\name{xlsx.from.dcm}
\alias{xlsx.from.dcm}
\title{Converting DICOM files to .xlsx files}
\usage{
xlsx.from.dcm(
  dcm.filenames,
  xlsx.filenames,
  multipage = TRUE,
  txt.sep = "\\\\",
  txt.length = 100,
  tag.dictionary = dicom.tag.dictionary()
)
}
\arguments{
\item{dcm.filenames}{String vector, representing the list of full names of
DICOM files.}

\item{xlsx.filenames}{String vector, representing the list of full names of
created *.xlsx files. If \code{multipage = TRUE}, only the \code{xlsx.filenames[1]}
is used.}

\item{multipage}{Boolean. If TRUE, all \code{dcm.filenames} are converted into
multiple pages of the same *.xlsx file.}

\item{txt.sep}{String. Used if \code{as.txt = TRUE}. Separator of the tag value elements.}

\item{txt.length}{Positive integer. Used if \code{as.txt = TRUE}. Maximum number
of letters in the representation of the TAG value.}

\item{tag.dictionary}{Dataframe, by default equal to \link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}
}
\value{
Returns a boolean vector, establishing the existence of the created
Excel files.
}
\description{
The \code{xlsx.from.dcm} function creates an Excel file from
DICOM files.
}
\examples{
# First, save toy.dicom.raw () raw data to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_dcm") 
dir.create (pat.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "PMrtplan", tmpdir = pat.dir, fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)
list.files (pat.dir)

# Creating an Excel file
xlsx.fnames <- file.path (pat.dir, 
                          paste (basename (dcm.filename),"xlsx", sep = "."))
xlsx.from.dcm (dcm.filename, xlsx.fnames)
list.files (pat.dir)

# Cleaning temporary directory
unlink (pat.dir, recursive = TRUE)
}
