% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_create.R
\name{vol.create}
\alias{vol.create}
\title{Volume creating}
\usage{
vol.create(
  n.ijk,
  dxyz,
  mid.pt = NULL,
  pt000 = NULL,
  default.value = NA,
  ref.pseudo = "ref1",
  frame.of.reference = "",
  alias = "",
  modality = "",
  description = "",
  number = 0
)
}
\arguments{
\item{n.ijk}{Vector of length 3, representing the number of elements on the i,
j and k axes.}

\item{dxyz}{Vector of length 3, representing the x, y, z steps in mm, between
voxels. See details.}

\item{mid.pt}{Vector of length 3, representing the x, y, z coordinates of the
midpoint  of the volume. See details.}

\item{pt000}{Vector of length 3, representing the x, y, z coordinates of the
first voxel of the first plane.}

\item{default.value}{Numerical or boolean value, representing the default
value of the voxels.}

\item{ref.pseudo}{Character string, frame of reference pseudonym of the
created object.By defaukt equal to "ref1"}

\item{frame.of.reference}{Character string, frame of reference of the
created object.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{modality}{Character string, \code{$modality} of the created object.}

\item{description}{Character string, describing the the created object.}

\item{number}{Integer, by default set to 0, number of the created object.}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), in which the grid is defined by  \code{pt000} or
\code{mid.pt}, \code{dxyz} \code{n.ijk}. If \code{default.value} are
initialized to \code{FALSE}, then \code{modality = "binary"}.
The orientation of the patient is orthonormal to the grid.
}
\description{
The \code{vol.create} function creates a volume object from a
user-defined grid.
}
\details{
If \code{mid.pt} and \code{pt000} are both equal to \code{NULL},
then \code{mid.pt = c (0, 0, 0)} by default.
If \code{mid.pt} and \code{pt000} are both different from \code{NULL}, then
only \code{mid.pt} is taken into account.
}
\examples{
new.vol <- vol.create (pt000 = c(1,10,10), dxyz = c (1 , 1, 1),
                       n.ijk = c(100, 100, 100),
                       ref.pseudo = "ref1",
                       frame.of.reference = "toyref1",
                       alias = "new ct", modality = "ct",
                       description = "")
str (new.vol)
}
