% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{match_geom_args}
\alias{match_geom_args}
\title{Match list of arguments to geometrie's arguments}
\usage{
match_geom_args(geom, args, add_aes = TRUE, mapping = list(),
  envir = "ggplot2")
}
\arguments{
\item{geom}{Character. name of the geometrie.}

\item{args}{Named list, parameters to match to geom's arguments.}

\item{add_aes}{Add aesthetics parameters (like size, fill, ...).}

\item{mapping}{Mapping used in plot, to avoid setting fixed aesthetics parameters.}

\item{envir}{Package environment to search in.}
}
\value{
a \code{list}
}
\description{
Match list of arguments to geometrie's arguments
}
\examples{
# List of parameters
params <- list(
  bins = 30,
  scale = "width",
  adjust = 2,
  position = "stack",
  size = 1.6,
  fill = "#112246"
)

# Search arguments according to geom
match_geom_args(geom = "histogram", args = params)
match_geom_args(geom = "violin", args = params)
match_geom_args(geom = "bar", args = params, add_aes = FALSE)
match_geom_args(geom = "point", args = params)
match_geom_args(geom = "point", args = params, add_aes = FALSE)
}
