% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-dragula.R
\name{dragulaInput}
\alias{dragulaInput}
\title{Drag And Drop Input Widget}
\usage{
dragulaInput(
  inputId,
  label = NULL,
  sourceLabel,
  targetsLabels,
  targetsIds = NULL,
  choices = NULL,
  choiceNames = NULL,
  choiceValues = NULL,
  selected = NULL,
  status = "primary",
  replace = FALSE,
  copySource = TRUE,
  badge = TRUE,
  ncolSource = "auto",
  ncolGrid = NULL,
  dragulaOpts = list(),
  boxStyle = NULL,
  width = NULL,
  height = "100px"
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{sourceLabel}{Label display in the source box}

\item{targetsLabels}{Labels for each target element.}

\item{targetsIds}{Ids for retrieving values server-side, if \code{NULL}, the default,
\code{targetsLabels} are used after removing all not-alphanumeric characters.}

\item{choices}{List of values to select from (if elements of the list are
named then that name rather than the value is displayed to the user).
If this argument is provided, then \code{choiceNames} and \code{choiceValues} must
not be provided, and vice-versa. The values should be strings; other
types (such as logicals and numbers) will be coerced to strings.}

\item{choiceNames, choiceValues}{List of names and values, respectively,
that are displayed to the user in the app and correspond to the each
choice (for this reason, \code{choiceNames} and \code{choiceValues} must have the same length).
If either of these arguments is provided, then the other must be provided and
choices must not be provided. The advantage of using both of these over a named
list for choices is that \code{choiceNames} allows any type of UI object to be passed
through (tag objects, icons, HTML code, ...), instead of just simple text.}

\item{selected}{Default selected values. Must be a \code{list} with \code{targetsIds} as names.}

\item{status}{If choices are displayed into a Bootstrap label, you can use Bootstrap
status to color them, or \code{NULL}.}

\item{replace}{When a choice is dragged in a target container already
containing a choice, does the later be replaced by the new one ?}

\item{copySource}{When \code{replace = TRUE}, does elements in source must be copied or moved ?}

\item{badge}{Displays choices inside a Bootstrap badge. Use \code{FALSE}
if you want to pass custom appearance with \code{choiceNames}.}

\item{ncolSource}{Number of columns occupied by the source, default is \code{"auto"}, meaning full row.}

\item{ncolGrid}{Number of columns used to place source and targets boxes, see examples.}

\item{dragulaOpts}{Options passed to dragula JavaScript library.}

\item{boxStyle}{CSS style string to customize source and target container.}

\item{width}{Width of the input.}

\item{height}{Height of each boxes, the total input height is this parameter X 2.}
}
\value{
a UI definition
}
\description{
Drag And Drop Input Widget
}
\note{
The output server-side is a list with two slots: \code{source} and \code{targets}.
}
\examples{
library(shiny)
library(esquisse)

ui <- fluidPage(
  tags$h2("Demo dragulaInput"),
  tags$br(),
  fluidRow(
    column(
      width = 6,
      
      dragulaInput(
        inputId = "dad1",
        label = "Default:",
        sourceLabel = "Source",
        targetsLabels = c("Target 1", "Target 2"),
        choices = month.abb,
        width = "100\%"
      ),
      verbatimTextOutput(outputId = "result1"),
      
      tags$br(),
      
      dragulaInput(
        inputId = "dad3",
        label = "On same row:",
        sourceLabel = "Source",
        targetsLabels = c("Target 1", "Target 2"),
        choices = month.abb,
        width = "100\%",
        ncolSource = 1,
        ncolGrid = 3
      ),
      verbatimTextOutput(outputId = "result3")
    ),
    
    column(
      width = 6,
      dragulaInput(
        inputId = "dad2",
        label = "Two rows:",
        sourceLabel = "Source",
        targetsLabels = c("x", "y", "color", "fill", "size", "facet"),
        choices = names(mtcars),
        width = "100\%",
        ncolGrid = 3
      ),
      verbatimTextOutput(outputId = "result2"),
      
      tags$br(),
      
      dragulaInput(
        inputId = "dad4",
        label = "Two rows not filled:",
        sourceLabel = "Source",
        targetsLabels = c("x", "y", "color", "fill", "size"),
        choices = names(mtcars),
        width = "100\%",
        ncolGrid = 3
      ),
      verbatimTextOutput(outputId = "result4")
    )
  )
)


server <- function(input, output, session) {
  
  output$result1 <- renderPrint(str(input$dad1))
  
  output$result2 <- renderPrint(str(input$dad2))
  
  output$result3 <- renderPrint(str(input$dad3))
  
  output$result4 <- renderPrint(str(input$dad4))
  
}

if (interactive())
  shinyApp(ui = ui, server = server)


}
\seealso{
\code{\link[=updateDragulaInput]{updateDragulaInput()}} to update choices server-side.
}
