% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esquisserServer.R, R/esquisserUI.R
\name{esquisserServer}
\alias{esquisserServer}
\alias{module-esquisse}
\alias{esquisserUI}
\title{Esquisse Shiny module}
\usage{
esquisserServer(
  input,
  output,
  session,
  data = NULL,
  dataModule = c("GlobalEnv", "ImportFile"),
  sizeDataModule = "m"
)

esquisserUI(
  id,
  header = TRUE,
  container = esquisseContainer(),
  choose_data = TRUE,
  insert_code = FALSE,
  disable_filters = FALSE
)
}
\arguments{
\item{input, output, session}{Standards \code{shiny} server arguments.}

\item{data}{A \code{reactiveValues} with at least a slot \code{data} containing a \code{data.frame}
to use in the module. And a slot \code{name} corresponding to the name of the \code{data.frame}.}

\item{dataModule}{Data module to use, choose between \code{"GlobalEnv"}
or \code{"ImportFile"}.}

\item{sizeDataModule}{Size for the modal window for selecting data.}

\item{id}{Module's id.}

\item{header}{Logical. Display or not \code{esquisse} header.}

\item{container}{Container in which display the addin,
default is to use \code{esquisseContainer}, see examples.
Use \code{NULL} for no container (behavior in versions <= 0.2.1).
Must be a \code{function}.}

\item{choose_data}{Logical. Display or not the button to choose data.}

\item{insert_code}{Logical, Display or not a button to insert the ggplot
code in the current user script (work only in RStudio).}

\item{disable_filters}{Logical. Disable the menu allowing to filter data used.}
}
\value{
A \code{reactiveValues} with 3 slots :
\itemize{
\item \strong{code_plot} : code to generate plot.
\item \strong{code_filters} : a list of length two with code to reproduce filters.
\item \strong{data} : \code{data.frame} used in plot (with filters applied).
}
}
\description{
DEPRECATED, see \code{\link{esquisse-module}}.
}
\note{
For the module to display correctly, it is necessary to place
it in a container with a fixed height. Since version >= 0.2.2, the
container is added by default.
}
