% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{which_pal_scale}
\alias{which_pal_scale}
\title{Automatically select appropriate color scale}
\usage{
which_pal_scale(
  mapping,
  palette = "ggplot2",
  data = NULL,
  fill_type = c("continuous", "discrete"),
  color_type = c("continuous", "discrete"),
  reverse = FALSE
)
}
\arguments{
\item{mapping}{Aesthetics used in \code{ggplot}.}

\item{palette}{Color palette.}

\item{data}{An optional \code{data.frame} to choose the right type for variables.}

\item{fill_type, color_type}{Scale to use according to the variable used
in \code{fill}/\code{color} aesthetic : \code{"discrete"} or \code{"continuous"}.
Ignored if \code{data} is provided: it will be guessed from data.}

\item{reverse}{Reverse colors order or not.}
}
\value{
a \code{list}
}
\description{
Automatically select appropriate color scale
}
\examples{
library(ggplot2)

# Automatic guess according to data
which_pal_scale(
  mapping = aes(fill = Sepal.Length),
  palette = "ggplot2",
  data = iris
)
which_pal_scale(
  mapping = aes(fill = Species),
  palette = "ggplot2",
  data = iris
)


# Explicitly specify type
which_pal_scale(
  mapping = aes(color = variable),
  palette = "Blues",
  color_type = "discrete"
)


# Both scales
which_pal_scale(
  mapping = aes(color = var1, fill = var2),
  palette = "Blues",
  color_type = "discrete",
  fill_type = "continuous"
)
}
