% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covarianza.R
\name{covarianza}
\alias{covarianza}
\title{Covarianza.}
\usage{
covarianza(x,
         variable = NULL,
         tipo = c("muestral","cuasi"))
}
\arguments{
\item{x}{Conjunto de datos. Es un dataframe con al menos 2 variables (2 columnas).}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de x. Si x solo tiene 2 variables (columnas), el argumento variable es NULL. En caso contrario, es necesario indicar el nombre o posición (número de columna) de las variables a seleccionar.}

\item{tipo}{Es un carácter. Por defecto de calcula la covarianza muestral (tipo = "muestral"). Si tipo = "cuasi", se calcula la cuasi-covarianza muestral.}
}
\value{
Esta función devuelve la covarianza en un objeto de la clase \code{data.frame}.
}
\description{
Calcula la covarianza.
}
\details{
(1) La covarianza muestral se obtiene a partir de la siguiente expresión:

\if{html}{\figure{covarianzamuestra.png}{options: width="50\%" alt="Figure: covarianzamuestra.png"}}
\if{latex}{\figure{covarianzamuestra.png}{options: scale=.5}}

(2) Muchos manuales y prácticamente todos los softwares (SPSS, Excel, etc.) calculan la covarianza a partir de la expresión:

\if{html}{\figure{covarianzacuasi.png}{options: width="50\%" alt="Figure: covarianzacuasi.png"}}
\if{latex}{\figure{covarianzacuasi.png}{options: scale=.5}}

Nosotros nos referimos a esta expresión como cuasi-covarianza muestral.
}
\note{
Si en lugar del tamaño muestral (n) se utiliza el tamaño de la población (N) se obtiene la covarianza poblacional:

\if{html}{\figure{covarianzapob.png}{options: width="50\%" alt="Figure: covarianzapob.png"}}
\if{latex}{\figure{covarianzapob.png}{options: scale=.5}}
}
\references{
Esteban García, J. y otros. (2005). Estadística descriptiva y nociones de probabilidad. Paraninfo. ISBN: 9788497323741

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673
}
\seealso{
\code{\link{varianza}}, \code{\link{desviacion}},\code{\link{matriz.covar}}
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

\strong{Cristina Pardo García}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
