% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.proporcion.R
\name{ic.proporcion}
\alias{ic.proporcion}
\title{Intervalo confianza de una proporción.}
\usage{
ic.proporcion(x,
          variable = NULL,
          introducir = FALSE,
          irrestricto = FALSE,
          confianza = 0.95,
          grafico = FALSE)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere una sola variable, \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de la variable.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante sobre tamaño muestral, valor de la media muestral, etc.}

\item{irrestricto}{Es un valor lógico. Por defecto, irrectricto = FALSE. si se considera un muestreo irrectricto (extracción sin reemplazamiento), cambiar el argumento a irrestricto = TRUE.}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}

\item{grafico}{Es un valor lógico. Por defecto \code{grafico = FALSE}. Si se quiere obtener una representación gráfica del intervalo de confianza obtenido, cambiar el argumento a \code{grafico = TRUE}. Nota: Esta opción no está implementada para todos los casos.}
}
\value{
Devuelve el intervalo de confianza de la proporción poblacional en un objeto de tipo \code{data.frame}. Si \code{grafico = T} devuelve una \code{list} con el intervalo de confianza y su representación gráfica.
}
\description{
Calcula el intervalo de confianza de una proporción.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qricproporcion.png}{options: width="25\%" alt="Figure: qricproporcion.png"}}
\if{latex}{\figure{qricproporcion.png}{options: width=3cm}}
}
\details{
(1) Para tamaños muestrales muy grandes (n>100):

\if{html}{\figure{icproporcion3.png}{options: width="80\%"}}
\if{latex}{\figure{icproporcion3.png}{options: width=12cm}}

El usuario puede elegir entre tres estrategias:

(1.1) En el error típico aproximar p por su estimación muestral.
(1.2) En el error típico considerar el caso: p=q=0.5
(1.3) Obtener el valor de p a partir del estadístico.

(2) Para cualquier tamaño muestral puede obtenerse el intervalo:

\if{html}{\figure{icproporcion1.png}{options: width="15\%"}}
\if{latex}{\figure{icproporcion1.png}{options: width=2.5cm}}

correspondiendo los valores a las raíces de:

\if{html}{\figure{icproporcion2.png}{options: width="80\%"}}
\if{latex}{\figure{icproporcion2.png}{options: width=12cm}}
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
