% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R, R/02_Beta.R, R/02_Binom.R,
%   R/02_Dirichlet.R, R/02_Exp.R, R/02_Gammad.R, R/02_MGamma.R, R/02_Norm.R,
%   R/02_Pois.R
\name{me}
\alias{me}
\alias{me,ANY,character-method}
\alias{me,numeric,Beta-method}
\alias{me,numeric,Binom-method}
\alias{me,matrix,Dirichlet-method}
\alias{me,numeric,Exp-method}
\alias{me,numeric,Gammad-method}
\alias{me,matrix,MGamma-method}
\alias{me,numeric,Norm-method}
\alias{me,numeric,Pois-method}
\title{Moment Estimation}
\usage{
me(x, distr, ...)

\S4method{me}{ANY,character}(x, distr, ...)

\S4method{me}{numeric,Beta}(x, distr)

\S4method{me}{numeric,Binom}(x, distr)

\S4method{me}{matrix,Dirichlet}(x, distr)

\S4method{me}{numeric,Exp}(x, distr)

\S4method{me}{numeric,Gammad}(x, distr)

\S4method{me}{matrix,MGamma}(x, distr, dirich = FALSE)

\S4method{me}{numeric,Norm}(x, distr)

\S4method{me}{numeric,Pois}(x, distr)
}
\arguments{
\item{x}{numeric. A sample under estimation.}

\item{distr}{A subclass of \code{Distribution}. The distribution family assumed.}

\item{...}{extra arguments.}

\item{dirich}{logical. Should the Dirichlet-based estimator be calculated
instead? Applies only to the Multivariate Gamma distribution.}
}
\value{
numeric. The estimator produced by the sample.
}
\description{
Calculates the ME under the assumption the sample observations are
independent and identically distributed (iid) according to a
specified family of distributions.
}
\examples{
# -------------------------------------------
# Beta Distribution Example
# -------------------------------------------

# Simulation
set.seed(1)
shape1 <- 1
shape2 <- 2
x <- rbeta(100, shape1, shape2)

library(distr)
D <- Beta(shape1, shape2)

# Likelihood - The ll Functions

llbeta(x, shape1, shape2)
ll(x, c(shape1, shape2), D)
ll(x, c(shape1, shape2), "beta")

# Point Estimation - The e Functions

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(x, D)
me(x, D)
same(x, D)

estim(x, D, type = "mle")

# Asymptotic Variance - The v Functions

vbeta(shape1, shape2, type = "mle")
vbeta(shape1, shape2, type = "me")
vbeta(shape1, shape2, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

avar(D, type = "mle")
}
\references{
Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.

Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.

Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.

Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.

Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
\seealso{
\link{estim}, \link{mle}, \link{same}
}
