% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.bc.mean.sd.R
\name{print.bc.mean.sd}
\alias{print.bc.mean.sd}
\title{Print method for objects of class "bc.mean.sd"}
\usage{
\method{print}{bc.mean.sd}(x, ...)
}
\arguments{
\item{x}{object of class "bc.mean.sd".}

\item{...}{other arguments.}
}
\value{
No value is returned.
}
\description{
Print method for objects of class "bc.mean.sd".
}
\examples{
## Generate S2 summary data
set.seed(1)
n <- 1000
x <- stats::rlnorm(n, 2.5, 1)
quants <- stats::quantile(x, probs = c(0.25, 0.5, 0.75))
obs.mean <- mean(x)
obs.sd <- stats::sd(x)

## Estimate the sample mean and standard deviation using the BC method
res <- bc.mean.sd(q1.val = quants[1], med.val = quants[2],
    q3.val = quants[3], n = n)
print(res)

}
\seealso{
\code{\link{bc.mean.sd}}
}
