% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_nonparametric_tests.R
\name{car_nonparametric_tests}
\alias{car_nonparametric_tests}
\title{Returns the result of given event study nonparametric CAR tests.}
\usage{
car_nonparametric_tests(
  list_of_returns,
  car_start,
  car_end,
  percentage = 90,
  all = TRUE,
  tests
)
}
\arguments{
\item{list_of_returns}{a list of objects of S3 class \code{returns}, each
element of which is treated as a security.}

\item{car_start}{an object of \code{Date} class giving the first date of
the CAR period.}

\item{car_end}{an object of \code{Date} class giving the last date of the
CAR period.}

\item{percentage}{a lowest allowed percentage of non-missing observation
for each day to be incorporated into CAR. The default value is 90 percent.}

\item{all}{a logical value indicating whether all tests should be performed.
The default value is \code{TRUE}. Note, only \code{car_rank_test} will be
performed.}

\item{tests}{a list of tests' functions. Currently, only \code{car_rank_test}
is allowed.}
}
\value{
A data frame of the following columns:
\itemize{
    \item \code{name}: a name of the test
    \item \code{car_start}: the first date of the CAR period
    \item \code{car_end}: the last date of the CAR period
    \item \code{average_percentage}: an average share of non-missing
          observations over the CAR period
    \item \code{statistic}: a test's statistic
    \item \code{number_of_days}: the number of days in the CAR period
    \item \code{significance}: a significance of the statistic
}
}
\description{
Performs given tests to examine the statistical significance of the CAR of a
given period.
}
\details{
Currently, \code{car_nonparametric_tests} performs only \code{car_rank_test}
test. This function was developed for the sake of completeness and can be
used for future extensions of the package.
}
\examples{
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^N100",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")
tickers <- c("ALV.DE", "CS.PA", "G.MI", "HNR1.HA", "HSX.L", "MUV2.DE",
             "RSA.L", "TOP.CO")
nine_eleven_car_param <- get_prices_from_tickers(tickers,
                                                 start = as.Date("2000-01-01"),
                                                 end = as.Date("2002-01-01"),
                                                 quote = "Close",
                                                 retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    apply_market_model(regressor = rates_indx,
                       same_regressor_for_all = TRUE,
                       market_model = "sim",
                       estimation_method = "ols",
                       estimation_start = as.Date("2001-03-26"),
                       estimation_end = as.Date("2001-09-10")) \%>\%
    car_nonparametric_tests(car_start = as.Date("2001-09-11"),
                            car_end = as.Date("2001-09-28"))
}
## The result of the code above is equivalent to:
data(securities_returns)
nine_eleven_car_param <- car_nonparametric_tests(
    list_of_returns = securities_returns,
    car_start = as.Date("2001-09-11"),
    car_end = as.Date("2001-09-28")
)

}
\references{
\itemize{
\item Corrado C.J. \emph{A Nonparametric Test for Abnormal Security-Price
Performance in Event Studies}. Journal of Financial Economics 23:385-395,
1989.
\item Cowan A.R. \emph{Nonparametric Event Study Tests}. Review of
Quantitative Finance and Accounting, 2:343-358, 1992.
}
}
\seealso{
\code{\link{car_rank_test}}.
}
