% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_calcs.R
\name{hedg_g}
\alias{hedg_g}
\title{Compute Hedges' \emph{g}
This function calculates effect sizes in terms of Hedges' \emph{g}, also
called the corrected (for sample size) effect size. See
\code{\link{coh_d}} for the uncorrected version. Also see 
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3840331/}{Lakens (2013)}
for a discussion on different types of effect sizes and their
interpretation. Note that missing data are removed from the calculations of 
the means and standard deviations.}
\usage{
hedg_g(formula, data, ref_group = NULL, tidy = TRUE)
}
\arguments{
\item{formula}{A formula of the type \code{out ~ group} where \code{out} is
the outcome variable and \code{group} is the grouping variable. Note this
variable can include any arbitrary number of groups.}

\item{data}{The data frame that the data in the formula come from.}

\item{ref_group}{Optional. If the name of the reference group is provided
(must be character and match the grouping level exactly), only the
estimates corresponding to the given reference group will be returned.}

\item{tidy}{Logical. Should the data be returned in a tidy data frame? (see
\href{http://journals.sagepub.com/doi/abs/10.3102/1076998611411918}{Wickham, 2014}). 
If false, effect sizes returned as a vector.}
}
\value{
By default the Hedges' \emph{d} for all possible pairings of
 the grouping factor are returned as a tidy data frame.
}
\description{
Compute Hedges' \emph{g}
This function calculates effect sizes in terms of Hedges' \emph{g}, also
called the corrected (for sample size) effect size. See
\code{\link{coh_d}} for the uncorrected version. Also see 
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3840331/}{Lakens (2013)}
for a discussion on different types of effect sizes and their
interpretation. Note that missing data are removed from the calculations of 
the means and standard deviations.
}
\examples{

# Calculate Hedges' g for all pairwise comparisons
hedg_g(reading ~ condition, star) 

# Report only relative to regular-sized classrooms
hedg_g(reading ~ condition, 
		star, 
		ref_group = "reg")

# Return a vector instead of a data frame
hedg_g(reading ~ condition, 
		star, 
		ref_group = "reg", 
		tidy = FALSE)
}
