% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etl_load.R
\name{etl_init}
\alias{etl_init}
\alias{etl_init.default}
\alias{find_schema}
\title{Initialize a database using a defined schema}
\usage{
etl_init(obj, script = NULL, schema_name = "init", pkg = attr(obj, "pkg"),
  ext = NULL, ...)

\method{etl_init}{default}(obj, script = NULL, schema_name = "init",
  pkg = attr(obj, "pkg"), ext = NULL, ...)

find_schema(obj, schema_name = "init", pkg = attr(obj, "pkg"), ext = NULL,
  ...)
}
\arguments{
\item{obj}{An \code{\link{etl}} object}

\item{script}{either a vector of SQL commands to be executed, or
a file path as a character vector containing an SQL initialization script.
If \code{NULL} (the default), then the appropriate built-in
schema will be fetched by \code{\link{find_schema}}, if it exists. Note
that the flavor of SQL in this file must match the type of the source. That is,
if your object is of type \code{\link[dplyr]{src_mysql}}, then make sure that
the schema you specify here is written in MySQL (and not PostgreSQL). Please
note that SQL syntax is not, in general, completely portable. Use with caution, as this may
clobber any existing data you have in an existing database.}

\item{schema_name}{The name of the schema. Default is \code{init}.}

\item{pkg}{The package defining the schema. Should be set in \code{\link{etl}}.}

\item{ext}{The file extension used for the SQL schema file. If NULL (the default) it
be inferred from the \code{src_*} class of \code{con}. For example, if \code{con}
has class \code{\link[dplyr]{src_sqlite}} then \code{ext} will be \code{sqlite}.}

\item{...}{Currently ignored}
}
\description{
Initialize a database using a defined schema
}
\details{
If the table definitions are at all non-trivial,
you may wish to include a pre-defined table schema. This function
will retrieve it.
}
\examples{
cars <- etl("mtcars")
cars \%>\%
  etl_init()
cars \%>\%
  etl_init(script = sql("CREATE TABLE IF NOT EXISTS mtcars_alt (id INTEGER);"))
cars \%>\%
  etl_init(schema_name = "init")
init_script <- find_schema(cars, schema_name = "init")
cars \%>\%
  etl_init(script = init_script, echo = TRUE)
src_tbls(cars)

cars <- etl("mtcars")
find_schema(cars)
find_schema(cars, "init", "etl")
find_schema(cars, "my_crazy_schema", "etl")

}

