% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trading.R
\name{etrd_place_mf_order}
\alias{etrd_place_mf_order}
\title{Place a Mutual Fund Order}
\usage{
etrd_place_mf_order(
  account,
  symbol,
  quantity,
  mfTransaction,
  reInvestOption = "REINVEST",
  quantityType = "DOLLAR",
  previewOrder = "df",
  etrade_cred = NULL,
  access_tokens = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{account}{The account ID key, not the account ID associated with the
specific account. Use \code{\link{etrd_account_list}} to identify the
proper account id key.}

\item{symbol}{The market symbol for the security being bought or sold}

\item{quantity}{The amount of the investment in either DOLLARS or
SHARES depending on the input for quantityType}

\item{mfTransaction}{The transaction for the mutual fund order. Options:    BUY,
SELL}

\item{reInvestOption}{Indicator flag to specify whether to reinvest profit on
mutual funds. Options: REINVEST, DEPOSIT, CURRENT_HOLDING}

\item{quantityType}{The type of the quantity - QUANTITY, DOLLAR, ALL_I_OWN
(note: DOLLAR is not yet an option)}

\item{previewOrder}{Elect to preview the order before submitting.  Options
are: 'df', 'json', or 'none' for an instant order entry. In a non
interactive environment will default to 'none'. This also indicates how the
order output is shown. json will return the output as a list, otherwise it
will return as a dataframe}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
A list or data frame of the order entry details
}
\description{
Submit a mutual fund order on the ETrade platform for the selected account.
Users are given the option to preview the order before submitting. Mutual
fund orders must be received before 4pm or will be executed the following
day.
}
\section{Warning}{
 TRADES THAT ARE SUCCESSFULLY ENTERED WILL BE SENT FOR
  EXECUTION. THIS FUNCTION HAS HUNDREDS OF POTENTIAL COMBINATIONS AND ONLY A
  HANDFUL HAVE BEEN TESTED. IT IS STRONGLY RECOMMENDED TO TEST THE DESIRED
  ORDER USING THE SANDBOX ENVIRONMENT. PLEASE NOTE THE SANDBOX ENVIRONMENT
  WILL NOT RETURN THE ORDER ENTERED, IT IS USED FOR CONFIRMING THE ORDER
  ENTRY HAS CORRECT SYNTAX. ORDERS CAN ALSO BE TESTED IN OFF MARKET HOURS ON
  A VERY SMALL QUANTITY WITH LITTLE MONEY AT STAKE. ETRADE HAS THEIR OWN
  ERROR HANDLING BUT IF A SUCCESSFUL COMBINATION IS ENTERED IT COULD BE
  EXECUTED UNINTENTIONALLY. DOUBLE CHECK ALL ENTRIES BEFORE SUBMITTING.
}

\examples{
\dontrun{

# Place Mutual Fund Buy order for $10
acts = etrd_account_list()
account = acts$accountIdKey[1]
etrd_place_mf_order(account = account,
                    symbol = 'SWTSX',
                    quantityType = 'DOLLAR',
                    quantity = 10,
                    mfTransaction = 'buy',
                    reInvestOption = 'reinvest',
                    previewOrder = 'df')

}
}
