% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_import.R
\name{importMetabase}
\alias{importMetabase}
\title{Import Eurostat ``Metabase''}
\usage{
importMetabase()
}
\value{
The imported data.frame which reflects the hierarchical
structure described above. It is a `flat' data.frame with 3 columns, where
each row corresponds to the combination of:
\itemize{
  \item \code{Code} -- Eurostat dataset code names,
  e.g. \code{"nama_10_a64"}
  \item \code{Dim_name} -- Eurostat dimension code names,
  e.g. \code{"nace_r2"}
  \item \code{Dim_val} -- Eurostat dimension code values,
  e.g. \code{"EU28"} if \code{Dim_name} is \code{"geo"};
  not to be confused with the actual numeric values
  in the actual datasets
}
}
\description{
The Eurostat ``Metabase'' shows which datasets contain which
dimensions (where a dimension is e.g. \code{geo} or \code{nace_r2}
or \code{indic_sb}) and, within each dataset and dimension,
which codes (e.g. which countries for the \code{geo} dimension).
}
\examples{
\dontrun{
importMetabase()
}
}
