% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_eurostat.R
\name{get_eurostat}
\alias{get_eurostat}
\title{Read data from Eurostat database.}
\usage{
get_eurostat(id, time_format = "date", cache = TRUE, update_cache = FALSE,
  cache_dir = NULL)
}
\arguments{
\item{id}{A code name for the data set of interest. See the table of contents of eurostat datasets for details.}

\item{time_format}{a string giving a type of the conversion of the time
column from the eurostat format. A "date" (default) convers to
a \code{\link{Date}} with a first date of the period.
A "date_last" convers to a \code{\link{Date}} with
  a last date of the period. A "num" convers to a numeric and "raw"
  does not do conversion. See \code{\link{eurotime2date}} and
  \code{\link{eurotime2num}}.}

\item{cache}{a logical wheather to do caching. Default is \code{TRUE}.}

\item{update_cache}{a locigal wheater to update cache. Can be set also with
options(eurostat_update = TRUE)}

\item{cache_dir}{a path to cache directory. The \code{NULL} uses directory
       eurostat directory in the temporary directory from
       \code{\link{tempdir}}. Directory can be set also with
       \code{option} eurostat_cache_dir.}
}
\value{
a data.frame. One column for each dimension in the data and
   the values column for numerical values.
   The time column for a time dimension.
}
\description{
Download dataset from the Eurostat database (\url{ec.europa.eu/eurostat}).
}
\details{
Datasets are downloaded from the Eurostat bulk download facility
\url{http://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing}. The data is transformed into the molten row-column-value format (RCV).

By default datasets are cached. In a temporary directory by default or in
a named directory if cache_dir or option eurostat_cache_dir is defined.
}
\examples{
\dontrun{
k <- get_eurostat("namq_aux_lp")
k <- get_eurostat("namq_aux_lp", update_cache = TRUE)
dir.create("r_cache")
k <- get_eurostat("namq_aux_lp", cache_dir = "r_cache")
options(eurostat_update = TRUE)
k <- get_eurostat("namq_aux_lp")
options(eurostat_cache_dir = "r_cache")
k <- get_eurostat("namq_aux_lp")
k <- get_eurostat("namq_aux_lp", cache = FALSE)
}
}
\seealso{
\code{{\link{tidy_eurostat}}}
}

