% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_json.R
\name{get_eurostat_json}
\alias{get_eurostat_json}
\title{Get data from The Eurostat APi in JSON}
\usage{
get_eurostat_json(id, filters = NULL, type = c("code", "label", "both"),
  lang = c("en", "fr", "de"), stringsAsFactors = default.stringsAsFactors())
}
\arguments{
\item{id}{A code name for the dataset of interested. See the table of
contents of eurostat datasets for more details.}

\item{filters}{A named list of filters. Names of list objects are 
Eurostat variable codes and values are vectors of observation codes. 
If \code{NULL} (default) the whole 
dataset is returned. See details for more on filters and 
limitations per query.}

\item{type}{A type of variables, "code" (default), "label" or "both". The 
"both" will return a data.frame with named vectors, labels as values 
and codes as names.}

\item{lang}{A language used for metadata (en/fr/de).}

\item{stringsAsFactors}{if \code{TRUE} (the default) variables are
converted to factors in original Eurostat order. If \code{FALSE}
they are returned as a character.}
}
\value{
A dataset as a data.frame.
}
\description{
Retrive data from 
   \href{http://ec.europa.eu/eurostat/web/json-and-unicode-web-services}{The Eurostat Web Services}. Data to retrive 
   can be spesified with filters. Normally, it is better to use JSON 
   query thru \code{\link{get_eurostat}}, than to use 
   \code{\link{get_eurostat_json}} directly.
}
\details{
Queryes are limited to 50 sub-indicators at a time.
   A time can be filtered with fixed "time" filter or with "sinceTimePeriod"
   and "lastTimePeriod" filters. A \code{sinceTimePeriod = 2000} returns
   observations from 2000 to a last available. A \code{lastTimePeriod = 10}
   returns a 10 last observations.
}
\examples{
 \dontrun{
   tmp <- get_eurostat_json("cdh_e_fos")
   yy <- get_eurostat_json("nama_gdp_c", filters = list(geo=c("EU28", "FI"), 
                                                        unit="EUR_HAB",
                                                        indic_na="B1GM")) 
}
}
\keyword{database}
\keyword{utilities}

