% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{FullPL}
\alias{FullPL}
\title{Computes latent trawl FULL pairwise likelihood depending with exponential
trawl function.}
\usage{
FullPL(times, values, alpha, beta, kappa, rho, delta, logscale = T,
  transformation = F, trawl.function = "exp")
}
\arguments{
\item{times}{Vector of timestamps.}

\item{values}{Vector of target values.}

\item{alpha}{Shape parameter. Should be positive.}

\item{beta}{Latent Gamma scale parameter. Should be positive.}

\item{kappa}{Exceedance probability parameter. Should be positive.}

\item{rho}{Trawl parameter(s). For \code{trawl.function="exp"}, it should be
positive.}

\item{delta}{Maximum depth of pairwise likelihood blocks. Should be positive
natural integer.}

\item{logscale}{Boolean to use logscale (log-likelihood). Default \code{T}.}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}

\item{trawl.function}{Type of trawl function that should be used. Default NA.}
}
\value{
Full latent trawl pairwise likelihood.
}
\description{
Computes latent trawl FULL pairwise likelihood depending with exponential
trawl function.
}
\examples{
\donttest{FullPL(times=1:10, values = seq(from=0.1, to=5, by=0.5), alpha=0.3,
  beta=2, kappa=3, rho=0.2, delta=2, T, F, "exp")}

}
